<?php
/**
 * Return SVG icons used by plugin
 * 
 * @package EasySocialShareButtons
 * @author appscreo
 * @since undefined
 */
class ESSB_SVG_Icons {
    
    /**
     * Register aliases of existing networks (share same icon)
     * @var array
     */
    public static $aliases = array(
        'yahoomail' => 'mail',
        'mailerlite' => 'subscribe',
        'mailchimp' => 'subscribe',
        'delicious' => 'del',
        'mailpoet' => 'subscribe',
        'mymail' => 'subscribe',
        'subscribe_form' => 'subscribe',
        'weheartit' => 'love',
        'total_followers' => 'love',
        'instgram' => 'instagram',
        'more' => 'plus',
        'less' => 'minus',
        'more_dots' => 'ellipsis-h',
        'dots' => 'ellipsis-h',
        'yahoomail' => 'mail',
        'envelope-o' => 'envelope',
        'twitter-x' =>  'twitter_x',
        'sidebar-close' => 'chevron-left',
        'sidebar-open' => 'chevron-right',
        'email' => 'mail'
    );
        
    /**
     * List of all icons
     * @var array
     */
    public static $icons = array(
        'facebook' => '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16"><path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951"></path></svg>',
        'facebook_like' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 408.788 408.788" style="enable-background:new 0 0 408.788 408.788;" xml:space="preserve"><path d="M353.701,0H55.087C24.665,0,0.002,24.662,0.002,55.085v298.616c0,30.423,24.662,55.085,55.085,55.085h147.275l0.251-146.078h-37.951c-4.932,0-8.935-3.988-8.954-8.92l-0.182-47.087c-0.019-4.959,3.996-8.989,8.955-8.989h37.882v-45.498c0-52.8,32.247-81.55,79.348-81.55h38.65c4.945,0,8.955,4.009,8.955,8.955v39.704c0,4.944-4.007,8.952-8.95,8.955l-23.719,0.011c-25.615,0-30.575,12.172-30.575,30.035v39.389h56.285c5.363,0,9.524,4.683,8.892,10.009l-5.581,47.087c-0.534,4.506-4.355,7.901-8.892,7.901h-50.453l-0.251,146.078h87.631c30.422,0,55.084-24.662,55.084-55.084V55.085C408.786,24.662,384.124,0,353.701,0z"/><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
        'twitter' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M28.75 9.5c0 0.25 0 0.563 0 0.813 0 8.688-6.625 18.688-18.688 18.688-3.688 0-7.188-1.063-10.063-2.938 0.5 0.063 1.063 0.063 1.563 0.063 3.063 0 5.938-1 8.188-2.813-2.875 0-5.313-1.938-6.188-4.563 0.438 0.125 0.813 0.125 1.25 0.125 0.625 0 1.188-0.063 1.75-0.188-3-0.625-5.25-3.313-5.25-6.438 0-0.063 0-0.063 0-0.125 0.875 0.5 1.875 0.813 2.938 0.813-1.75-1.125-2.938-3.188-2.938-5.438 0-1.188 0.375-2.313 0.938-3.313 3.188 4 8.063 6.625 13.5 6.875-0.125-0.5-0.188-1-0.188-1.5 0-3.625 2.938-6.563 6.563-6.563 1.938 0 3.625 0.813 4.813 2.063 1.5-0.313 2.938-0.813 4.188-1.563-0.5 1.5-1.563 2.813-2.875 3.625 1.313-0.188 2.563-0.5 3.75-1.063-0.875 1.313-2 2.5-3.25 3.438z"></path></svg>',
        'twitter_x' => '<svg viewBox="0 0 24 24" aria-hidden="true" class="r-18jsvk2 r-4qtqp9 r-yyyyoo r-16y2uox r-8kz0gk r-dnmrzs r-bnwqim r-1plcrui r-lrvibr r-lrsllp"><g><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"></path></g></svg>',
        'pinterest' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.625 12.25c0-1.375 0.313-2.5 1.063-3.438 0.688-0.938 1.563-1.438 2.563-1.438 0.813 0 1.438 0.25 1.875 0.813s0.688 1.25 0.688 2.063c0 0.5-0.125 1.125-0.313 1.813-0.188 0.75-0.375 1.625-0.688 2.563-0.313 1-0.563 1.75-0.688 2.313-0.25 1-0.063 1.875 0.563 2.625 0.625 0.688 1.438 1.063 2.438 1.063 1.75 0 3.188-1 4.313-2.938 1.125-2 1.688-4.375 1.688-7.188 0-2.125-0.688-3.875-2.063-5.25-1.375-1.313-3.313-2-5.813-2-2.813 0-5.063 0.875-6.75 2.688-1.75 1.75-2.625 3.875-2.625 6.375 0 1.5 0.438 2.75 1.25 3.75 0.313 0.313 0.375 0.688 0.313 1.063-0.125 0.313-0.25 0.813-0.375 1.5-0.063 0.25-0.188 0.438-0.375 0.5s-0.375 0.063-0.563 0c-1.313-0.563-2.25-1.438-2.938-2.75s-1-2.813-1-4.5c0-1.125 0.188-2.188 0.563-3.313s0.875-2.188 1.625-3.188c0.75-1.063 1.688-1.938 2.688-2.75 1.063-0.813 2.313-1.438 3.875-1.938 1.5-0.438 3.125-0.688 4.813-0.688 1.813 0 3.438 0.313 4.938 0.938 1.5 0.563 2.813 1.375 3.813 2.375 1.063 1.063 1.813 2.188 2.438 3.5 0.563 1.313 0.875 2.688 0.875 4.063 0 3.75-0.938 6.875-2.875 9.313-1.938 2.5-4.375 3.688-7.375 3.688-1 0-1.938-0.188-2.813-0.688-0.875-0.438-1.5-1-1.875-1.688-0.688 2.938-1.125 4.688-1.313 5.25-0.375 1.438-1.25 3.188-2.688 5.25h-1.313c-0.25-2.563-0.188-4.688 0.188-6.375l2.438-10.313c-0.375-0.813-0.563-1.813-0.563-3.063z"></path></svg>',
        'linkedin' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.938 16.375c-0.438-0.5-1.188-0.75-2.25-0.75-1.375 0-2.313 0.438-2.875 1.188-0.563 0.813-0.813 1.938-0.813 3.375v10.938c0 0.188-0.063 0.375-0.25 0.563-0.125 0.125-0.375 0.25-0.563 0.25h-5.75c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-20.188c0-0.188 0.125-0.375 0.25-0.563 0.188-0.125 0.375-0.25 0.563-0.25h5.563c0.188 0 0.375 0.063 0.5 0.125s0.188 0.25 0.25 0.438c0 0.188 0.063 0.375 0.063 0.438s0 0.25 0 0.5c1.438-1.375 3.375-2 5.688-2 2.688 0 4.75 0.625 6.25 1.938 1.5 1.375 2.25 3.313 2.25 5.938v13.625c0 0.188-0.063 0.375-0.25 0.563-0.125 0.125-0.375 0.25-0.563 0.25h-5.875c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-12.313c0-1.063-0.188-1.875-0.563-2.438zM6.625 6.688c-0.75 0.75-1.688 1.125-2.75 1.125s-2-0.375-2.75-1.125c-0.75-0.75-1.125-1.625-1.125-2.75 0-1.063 0.375-1.938 1.125-2.688s1.688-1.188 2.75-1.188c1.063 0 2 0.438 2.75 1.188s1.125 1.625 1.125 2.688c0 1.125-0.375 2-1.125 2.75zM7.563 10.938v20.188c0 0.188-0.125 0.375-0.25 0.563-0.188 0.125-0.375 0.25-0.563 0.25h-5.75c-0.188 0-0.375-0.125-0.563-0.25-0.125-0.188-0.25-0.375-0.25-0.563v-20.188c0-0.188 0.125-0.375 0.25-0.563 0.188-0.125 0.375-0.25 0.563-0.25h5.75c0.188 0 0.375 0.125 0.563 0.25 0.125 0.188 0.25 0.375 0.25 0.563z"></path></svg>',
        'digg' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M5.1,10.7V6h3.2v15.7H0V10.8L5.1,10.7z M5.1,19.1v-5.8H3.2v5.8H5.1z M23.7,10.7H32V26h-8.3v-2.6h5.1v-1.8h-5.1L23.7,10.7z M28.8,19.1v-5.8h-1.9v5.8H28.8z M14.1,21.7V10.7h8.3V26h-8.3v-2.6h5.1v-1.8L14.1,21.7z M17.2,13.3v5.8h1.9v-5.8H17.2z M12.8,6v3.2H9.6V6H12.8z M12.8,10.7v10.9H9.6V10.7L12.8,10.7z"/></svg>',
        'del' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 16h-16v16h-16v-16h16v-16h16z"></path></svg>',
        'tumblr' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.125 13.125v-4.563c1.25-0.375 2.375-1 3.25-1.75s1.625-1.688 2.125-2.75c0.563-1.063 0.938-2.438 1.125-4.063h4.563v8.063h7.625v5.063h-7.625v8.188c0 1.875 0.125 3.063 0.313 3.563 0.188 0.563 0.563 0.938 1.063 1.25 0.75 0.438 1.563 0.688 2.438 0.688 1.625 0 3.25-0.563 4.875-1.625v5.063c-1.375 0.625-2.625 1.125-3.75 1.375-1.063 0.25-2.313 0.375-3.563 0.375-1.5 0-2.75-0.188-3.875-0.563s-2.125-0.875-2.875-1.563c-0.813-0.688-1.375-1.438-1.688-2.188s-0.438-1.875-0.438-3.375v-11.188z"></path></svg>',
        'vk' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.938 22.063c-0.938-1.25-1.75-2-2.938-3.125-0.5-0.5-1.188-1-1.25-1.688-0.063-0.938 0.813-1.813 1.25-2.438 0.063-0.063 0.125-0.125 0.188-0.188s0.063-0.063 0.125-0.125c0-0.063 0.063-0.063 0.063-0.125 0.063-0.063 0.063-0.125 0.125-0.125 0-0.063 0.063-0.063 0.063-0.063 0.063-0.063 0.063-0.125 0.125-0.188 0.813-1.063 1.625-2 2.438-3.25 0.25-0.438 1.063-2 0.813-2.625-0.375-0.75-2.313-0.5-3.375-0.5-1.313 0-2.75-0.25-3.688 0.125-0.563 0.188-0.938 1.438-1.25 2.125-0.5 1.063-0.938 1.938-1.438 2.75 0 0.063-0.063 0.125-0.125 0.188 0 0 0 0 0 0 0 0.063-0.063 0.125-0.125 0.188 0 0 0 0 0 0-0.063 0.125-0.125 0.25-0.188 0.313 0 0.063-0.063 0.063-0.063 0.063 0 0.063-0.063 0.063-0.063 0.125-0.063 0.063-0.063 0.063-0.063 0.125-0.063 0-0.063 0.063-0.125 0.125 0 0-0.063 0.063-0.063 0.125-0.063 0-0.063 0.063-0.063 0.063-0.063 0.063-0.125 0.125-0.188 0.25-0.438 0.625-0.875 1.375-1.688 1.5-0.063-0.063-0.063-0.063-0.125-0.063 0 0 0-0.063 0-0.063-0.063 0-0.063 0-0.063 0 0-0.063-0.063-0.063-0.063-0.063s0 0-0.063-0.063c0 0 0 0 0 0s0-0.063-0.063-0.063c0 0 0 0 0 0 0-0.063-0.063-0.063-0.063-0.063s0-0.063 0-0.063c0 0-0.063 0-0.063-0.063 0 0 0 0 0 0 0-0.063 0-0.063-0.063-0.063 0 0 0-0.063 0-0.063s0 0 0-0.063c0 0-0.063 0-0.063 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0-0.063-0.063-0.063-0.063-0.063-0.063 0-0.063 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063-0.063-0.063 0 0 0-0.063 0-0.063s0 0 0-0.063c0 0 0 0 0-0.063 0 0 0 0 0 0 0-0.063 0-0.063-0.063-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0-0.063 0-0.063-0.063 0 0 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063 0-0.063s0-0.063 0-0.063c0 0 0-0.063 0-0.063 0-0.063 0.063-0.063 0.063-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.063 0-0.063 0-0.125 0 0 0 0 0 0 0-0.188 0-0.313 0-0.5 0 0 0-0.063 0-0.063 0-0.125 0-0.313 0.063-0.438 0-1.375 0.438-3.188-0.188-4.25-0.563-0.938-2.688-0.813-4.188-0.813-1.813 0-3.25 0.125-3.813 1.188 0.625 0.438 1.313 0.438 1.625 1.063 0.375 0.688 0.438 2.125 0.375 3.438 0 0.063 0 0.125 0 0.188 0 1.125-0.063 2.938-0.813 3.063s-1.375-1-1.813-1.563c-0.063-0.125-0.125-0.188-0.188-0.313 0 0-0.063-0.063-0.063-0.063-0.063-0.063-0.063-0.125-0.125-0.25 0 0-0.063-0.063-0.063-0.063-0.063-0.063-0.125-0.125-0.125-0.188-0.063-0.063-0.063-0.063-0.063-0.125-0.063-0.063-0.125-0.188-0.188-0.25-0.563-0.938-1.125-1.875-1.625-3.063-0.375-0.688-0.813-1.875-1.188-2.063-0.75-0.375-2.25-0.188-3.25-0.188-1.125 0-2.313-0.188-3 0.375 0 1.25 0.625 2.313 1.125 3.313 0.688 1.375 1.375 2.688 2.125 3.938 0 0.063 0.063 0.125 0.063 0.188 0.125 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.063 0.188 0.125 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.125 0.188 0.25 0.375 0.375 0.563 0 0 0 0 0 0 0.125 0.188 0.25 0.438 0.375 0.625 0.063 0.063 0.063 0.125 0.125 0.125 0.125 0.188 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.063 0.125 0.188 0.313 0.313 0.438 0 0.063 0.063 0.125 0.125 0.188 0.125 0.188 0.25 0.375 0.438 0.563 1.938 2.438 4.125 4.75 8.438 5.25 1.375 0.125 3.375 0.25 3.813-0.563 0.625-1-0.063-3.375 1.313-3.563 0.938-0.188 1.75 1.25 2.313 1.813 0.938 1.063 2.063 2.188 3.688 2.5 0 0 0.063 0 0.125 0 1.438-0.625 5.75 0.688 6-1.125 0.063-0.625-0.688-1.625-1.063-2.063z"></path></svg>',
        'print' => '<svg width="30" height="32" viewBox="0 0 30 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.857 27.714h16v-4.571h-16v4.571zM6.857 16.286h16v-6.857h-2.857c-0.946 0-1.714-0.768-1.714-1.714v-2.857h-11.429v11.429zM27.429 17.429c0-0.625-0.518-1.143-1.143-1.143s-1.143 0.518-1.143 1.143 0.518 1.143 1.143 1.143 1.143-0.518 1.143-1.143zM29.714 17.429v7.429c0 0.304-0.268 0.571-0.571 0.571h-4v2.857c0 0.946-0.768 1.714-1.714 1.714h-17.143c-0.946 0-1.714-0.768-1.714-1.714v-2.857h-4c-0.304 0-0.571-0.268-0.571-0.571v-7.429c0-1.875 1.554-3.429 3.429-3.429h1.143v-9.714c0-0.946 0.768-1.714 1.714-1.714h12c0.946 0 2.25 0.536 2.929 1.214l2.714 2.714c0.679 0.679 1.214 1.982 1.214 2.929v4.571h1.143c1.875 0 3.429 1.554 3.429 3.429z" /></svg>',
        'subscribe' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 12.964v14.179c0 1.571-1.286 2.857-2.857 2.857h-26.286c-1.571 0-2.857-1.286-2.857-2.857v-14.179c0.536 0.589 1.143 1.107 1.804 1.554 2.964 2.018 5.964 4.036 8.875 6.161 1.5 1.107 3.357 2.464 5.304 2.464h0.036c1.946 0 3.804-1.357 5.304-2.464 2.911-2.107 5.911-4.143 8.893-6.161 0.643-0.446 1.25-0.964 1.786-1.554zM32 7.714c0 2-1.482 3.804-3.054 4.893-2.786 1.929-5.589 3.857-8.357 5.804-1.161 0.804-3.125 2.446-4.571 2.446h-0.036c-1.446 0-3.411-1.643-4.571-2.446-2.768-1.946-5.571-3.875-8.339-5.804-1.268-0.857-3.071-2.875-3.071-4.5 0-1.75 0.946-3.25 2.857-3.25h26.286c1.554 0 2.857 1.286 2.857 2.857z"/></svg>',
        'mail' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 60 60" style="enable-background:new 0 0 60 60;" xml:space="preserve"><g><polygon points="60,50.234 60,9.944 39.482,30.536 "/><polygon points="0,9.941 0,50.234 20.519,30.535 "/><path d="M1.387,8.5l21.002,21.08c0.121,0.051,0.471,0.415,0.517,0.519l5.941,5.963c0.635,0.591,1.672,0.59,2.333-0.025l5.911-5.933c0.046-0.105,0.4-0.473,0.522-0.524L58.615,8.5H1.387z"/><path d="M38.07,31.954l-5.5,5.52c-0.73,0.68-1.657,1.019-2.58,1.019c-0.914,0-1.823-0.332-2.533-0.993l-5.526-5.546L1.569,51.5h56.862L38.07,31.954z"/></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
        'flattr' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.2,13v8.4L0,28.6V12.1C0,4.1,3.7,0,11.2,0h9.2h8.4L16.3,12.4c-0.2,0.2-0.3,0.2-0.4,0.2c-0.2,0-0.4-0.2-0.5-0.4v-0.2v-5c-2.7,0-4.1,0.1-4.5,0.1C8.4,7.6,7.2,9.6,7.2,13 M24.8,10.5L32,3.3v16.5C32,27.9,28.3,32,20.8,32h-9.2H3.3l12.5-12.5c0.1-0.2,0.2-0.2,0.3-0.2c0.2,0,0.4,0.2,0.5,0.4v0.2v5c2.7,0,4.1-0.1,4.5-0.1c2.5-0.5,3.7-2.4,3.7-5.9V10.5"/></svg>',
        'reddit' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M18.8,2.7c-2.2,0-3.9,1.8-3.9,3.9v3.6c-2.9,0.2-5.6,0.9-7.8,2.2c-0.8-0.8-1.9-1.1-3-1.1c-1.2,0-2.3,0.4-3.2,1.3v0l0,0c-0.8,1-1.1,2.3-0.9,3.6c0.2,1.2,0.9,2.4,2.1,3.2c0,0.1,0,0.2,0,0.4c0,2.8,1.7,5.2,4.2,6.9s5.9,2.7,9.7,2.7s7.1-1,9.7-2.7s4.2-4.1,4.2-6.9c0-0.1,0-0.2,0-0.4c1.2-0.8,1.9-2,2.1-3.2c0.2-1.3-0.1-2.6-0.9-3.6l0,0c-0.8-0.9-2-1.3-3.2-1.3c-1.1,0-2.2,0.3-3,1.1c-2.2-1.2-4.8-2-7.8-2.2V6.6c0-1,0.6-1.8,1.8-1.8c0.6,0,1.2,0.3,2.3,0.6c0.9,0.3,2.1,0.7,3.6,0.8C25.1,7.2,26,8,27.2,8c1.5,0,2.7-1.2,2.7-2.7s-1.2-2.7-2.7-2.7c-1,0-1.9,0.6-2.3,1.4c-1.3-0.1-2.2-0.3-3-0.6C20.9,3.1,20,2.7,18.8,2.7z M16,12.3c3.4,0,6.4,0.9,8.5,2.3s3.3,3.2,3.3,5.1s-1.2,3.7-3.3,5.1s-5.1,2.3-8.5,2.3s-6.4-0.9-8.5-2.3s-3.3-3.2-3.3-5.1s1.2-3.7,3.3-5.1S12.6,12.3,16,12.3z M4.2,13.3c0.4,0,0.8,0.1,1.1,0.3c-1.2,1-2.1,2.1-2.6,3.4c-0.3-0.3-0.4-0.8-0.5-1.2c-0.1-0.7,0.1-1.5,0.4-1.9c0,0,0,0,0,0C3,13.6,3.5,13.3,4.2,13.3z M27.8,13.3c0.6,0,1.2,0.2,1.5,0.6c0,0,0,0,0,0c0.3,0.4,0.6,1.2,0.4,1.9c-0.1,0.4-0.2,0.8-0.5,1.2c-0.5-1.3-1.4-2.4-2.6-3.4C27,13.4,27.4,13.3,27.8,13.3z M10.7,15.5c-1.2,0-2.1,1-2.1,2.1c0,1.2,1,2.1,2.1,2.1s2.1-1,2.1-2.1C12.8,16.4,11.8,15.5,10.7,15.5z M21.3,15.5c-1.2,0-2.1,1-2.1,2.1c0,1.2,1,2.1,2.1,2.1c1.2,0,2.1-1,2.1-2.1C23.5,16.4,22.5,15.5,21.3,15.5z M21.6,21.4c-1.2,1.1-3.3,1.9-5.6,1.9s-4.4-0.7-5.6-1.7c0.7,1.9,2.9,3.6,5.6,3.6S20.9,23.4,21.6,21.4z"/></svg>',
        'buffer' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.438 24.313c-0.063-0.063-0.188-0.125-0.25-0.188-0.813-0.375-1.688-0.75-2.5-1.125-0.688-0.375-1.438-0.375-2.188 0-3.125 1.438-6.25 2.938-9.375 4.375-0.75 0.313-1.5 0.375-2.188 0-3.125-1.438-6.313-2.938-9.438-4.375-0.75-0.375-1.5-0.375-2.25 0s-1.563 0.75-2.313 1.063c-0.25 0.125-0.625 0.25-0.625 0.625 0 0.313 0.375 0.375 0.625 0.5 4.625 2.188 9.25 4.375 13.938 6.5 0.75 0.375 1.5 0.375 2.188 0.063 4.688-2.188 9.375-4.375 14.063-6.563 0.125-0.063 0.25-0.125 0.313-0.188 0.313-0.188 0.313-0.5 0-0.688zM0.5 7.688c0.125 0.063 0.313 0.188 0.438 0.25 4.688 2.125 9.313 4.313 13.938 6.5 0.75 0.313 1.5 0.313 2.25 0 4.625-2.188 9.313-4.375 13.938-6.5 0.125-0.125 0.313-0.188 0.438-0.313 0.25-0.125 0.25-0.375 0-0.563-0.125-0.125-0.313-0.188-0.438-0.313-4.625-2.125-9.25-4.313-13.875-6.438-0.813-0.375-1.563-0.375-2.375 0-4.625 2.125-9.25 4.313-13.875 6.5-0.188 0.063-0.313 0.125-0.438 0.188-0.25 0.188-0.25 0.5 0 0.688zM31.438 15.688c-0.063-0.063-0.188-0.125-0.25-0.188-0.813-0.375-1.688-0.75-2.5-1.125-0.688-0.375-1.438-0.375-2.188 0-3.125 1.438-6.25 2.938-9.375 4.375-0.75 0.313-1.5 0.313-2.188 0-3.125-1.438-6.313-2.938-9.438-4.375-0.75-0.375-1.5-0.375-2.25 0s-1.563 0.75-2.313 1.063c-0.25 0.125-0.625 0.25-0.625 0.563 0 0.375 0.375 0.438 0.625 0.563 4.625 2.188 9.25 4.375 13.938 6.5 0.75 0.375 1.5 0.375 2.188 0.063 4.688-2.188 9.375-4.375 14.063-6.563 0.125-0.063 0.25-0.125 0.313-0.188 0.313-0.188 0.313-0.5 0-0.688z"/></svg>',
        'love' => '<svg version="1.1" height="32" width="37" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 37 32" ><path d="M33.2,2.2c-3.9-3.3-9.7-2.7-13.3,1l-1.4,1.4l-1.4-1.4c-3.6-3.7-9.4-4.3-13.3-1C-0.7,6-1,12.9,3.1,17l13.8,14.3c0.9,0.9,2.3,0.9,3.2,0L33.9,17C38,12.9,37.7,6,33.2,2.2L33.2,2.2z"/></svg>',
        'weibo' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M23.5,16.1c-0.4-0.1-0.7-0.2-0.5-0.8c0.5-1.3,0.6-2.4,0-3.2c-1-1.5-3.8-1.4-7,0c0,0-1,0.4-0.7-0.4c0.5-1.6,0.4-2.9-0.3-3.7c-1.7-1.8-6.3,0.1-10.3,4.1c-3,3-4.7,6.2-4.7,9c0,5.3,6.6,8.8,13.1,8.8c8.5,0,14.2-5.4,14.2-9.4C27.3,18,25.3,16.7,23.5,16.1z M13.2,27.5C8,28,3.5,25.6,3.2,22.2c-0.3-3.4,3.6-6.6,8.8-7.1c5.2-0.5,9.7,1.8,10,5.3C22.3,23.8,18.4,26.9,13.2,27.5z M32,11.8c0-5.3-4.3-9.6-9.6-9.6l0,0c-0.6,0-1.1,0.5-1.1,1.1s0.5,1.1,1.1,1.1c4.1,0,7.4,3.3,7.4,7.4c0,0.6,0.5,1.1,1.1,1.1C31.5,12.9,32,12.4,32,11.8L32,11.8C32,11.8,32,11.8,32,11.8z M27.5,11.6c-0.5-2.5-2.5-4.5-5-5c-0.6-0.1-1.2,0.2-1.4,0.8C21,8.1,21.4,8.7,22,8.8c0,0,0,0,0.1,0c1.6,0.3,2.9,1.6,3.3,3.3c0.1,0.6,0.7,1,1.3,0.9C27.3,12.9,27.7,12.3,27.5,11.6z M10.5,18.4c-2.1,0.4-3.5,2.2-3.2,3.9c0.4,1.7,2.3,2.8,4.4,2.4c2.1-0.4,3.5-2.2,3.2-3.9C14.6,19.1,12.6,18,10.5,18.4z"/></svg>',
        'pocket' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 5.5c0-0.875 0.063-1.688-0.438-2.438-0.375-0.563-1-1.063-1.625-1.25-0.875-0.25-1.813-0.188-2.625-0.125-3.75 0-7.563-0.063-11.313-0.063-0.438 0-0.813 0-1.25 0-0.5 0-1 0-1.563 0-1.813 0-3.688 0-5.563 0-0.938 0-1.875 0-2.813 0-0.5 0-1 0-1.5 0-0.438 0-0.813 0-1.188 0.125-1.313 0.375-2.125 1.625-2.125 3 0 1.875 0 3.75 0 5.625 0 1.813-0.063 3.688 0.063 5.563 0.125 1.688 0.625 3.438 1.313 5 1.313 2.813 3.438 5.188 6.063 6.875 2.875 1.813 6.313 2.688 9.688 2.438 3.313-0.25 6.5-1.563 9.063-3.688 2.438-1.938 4.188-4.563 5.125-7.5 0.5-1.688 0.688-3.5 0.688-5.25 0-1.813 0-3.688 0-5.563 0-0.938 0-1.875 0-2.75zM25.625 12.75c-0.188 0.813-1 1.375-1.563 1.938-1.438 1.375-2.875 2.75-4.313 4.063-0.75 0.75-1.438 1.438-2.188 2.125-0.563 0.5-1.313 0.75-2.063 0.563-0.875-0.188-1.5-1-2.063-1.563-0.75-0.688-1.438-1.375-2.125-2-1.438-1.375-2.875-2.75-4.313-4.188-1.063-1.063-0.875-3 0.625-3.625 0.688-0.25 1.5-0.188 2.063 0.188 0.375 0.313 0.75 0.625 1.063 1 0.375 0.313 0.75 0.688 1.063 1 1.438 1.375 2.75 2.75 4.188 4 1.625-1.5 3.25-3.063 4.875-4.625 0.688-0.625 1.313-1.5 2.313-1.688 0.75-0.125 1.563 0.188 2.063 0.75 0.438 0.563 0.625 1.375 0.375 2.063z"/></svg>',
        'xing' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.688 22.438h-4.625c-0.25 0-0.438-0.125-0.563-0.313s-0.125-0.5 0-0.75l4.875-8.625c0 0 0 0 0-0.063l-3.125-5.375c-0.125-0.25-0.125-0.5 0-0.688s0.313-0.313 0.625-0.313h4.625c0.688 0 1.063 0.438 1.25 0.875 0 0 3.188 5.5 3.188 5.5-0.188 0.375-5 8.813-5 8.813-0.25 0.438-0.563 0.938-1.25 0.938zM29.5 1l-10.188 18.063c0 0 0 0.063 0 0.063l6.5 11.875c0.125 0.25 0.125 0.5 0 0.688s-0.313 0.313-0.625 0.313h-4.625c-0.688 0-1-0.5-1.25-0.875 0 0-6.563-12-6.563-12.063 0.313-0.563 10.25-18.188 10.25-18.188 0.25-0.438 0.563-0.875 1.25-0.875h4.688c0.25 0 0.5 0.125 0.563 0.313 0.125 0.188 0.125 0.438 0 0.688z"></path></svg>',
        'ok' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><title>Odnoklassniki icon</title><path d="M19.4,23.3c1.7-0.4,3.3-1.1,4.8-2c1.1-0.7,1.4-2.2,0.7-3.4c-0.7-1.1-2.1-1.4-3.2-0.7c-3.4,2.1-7.7,2.1-11.1,0c-1.1-0.7-2.6-0.4-3.3,0.8c0,0,0,0,0,0c-0.7,1.1-0.4,2.6,0.8,3.3l0,0c1.5,0.9,3.1,1.6,4.8,2l-4.6,4.6c-0.9,0.9-1,2.4,0,3.4l0,0C8.5,31.8,9.1,32,9.8,32c0.6,0,1.2-0.2,1.7-0.7l4.6-4.5l4.5,4.5c1,0.9,2.5,0.9,3.4-0.1c0.9-0.9,0.9-2.4,0-3.4C24,27.9,19.4,23.3,19.4,23.3z M16,16.5c4.6,0,8.3-3.7,8.3-8.3C24.3,3.7,20.6,0,16,0S7.8,3.7,7.8,8.3C7.8,12.8,11.5,16.5,16,16.5L16,16.5z M16,4.8c1.9,0,3.4,1.5,3.4,3.4c0,1.9-1.5,3.4-3.4,3.4c-1.9,0-3.4-1.5-3.4-3.4C12.6,6.4,14.1,4.8,16,4.8L16,4.8z"/></svg>',
        'whatsapp' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.313 4.625c-3-3-7-4.625-11.25-4.625-8.75 0-15.875 7.125-15.875 15.875 0 2.75 0.75 5.5 2.125 7.938l-2.25 8.188 8.438-2.188c2.313 1.25 4.875 1.938 7.563 1.938v0c0 0 0 0 0 0 8.75 0 15.875-7.125 15.875-15.875 0-4.25-1.625-8.25-4.625-11.25zM16.063 29.063v0c-2.375 0-4.688-0.625-6.688-1.875l-0.5-0.25-5 1.313 1.313-4.875-0.313-0.5c-1.313-2.125-2-4.5-2-7 0-7.313 5.938-13.188 13.188-13.188 3.5 0 6.813 1.375 9.313 3.875s3.875 5.813 3.875 9.313c0 7.25-5.938 13.188-13.188 13.188zM23.313 19.188c-0.438-0.188-2.375-1.188-2.75-1.313-0.313-0.125-0.625-0.188-0.875 0.188-0.25 0.438-1 1.313-1.25 1.563s-0.438 0.313-0.875 0.125c-0.375-0.188-1.625-0.625-3.188-2-1.125-1-1.938-2.313-2.188-2.75-0.25-0.375 0-0.563 0.188-0.813 0.188-0.125 0.375-0.438 0.563-0.688 0.25-0.188 0.313-0.375 0.438-0.625s0.063-0.5-0.063-0.688c-0.063-0.188-0.875-2.188-1.188-2.938-0.375-0.813-0.688-0.688-0.938-0.688-0.188 0-0.5 0-0.75 0s-0.688 0.063-1.063 0.438c-0.375 0.438-1.375 1.375-1.375 3.313 0 2 1.438 3.875 1.625 4.125s2.813 4.25 6.75 6c0.938 0.375 1.688 0.625 2.25 0.813 1 0.313 1.813 0.25 2.5 0.188 0.813-0.125 2.375-1 2.688-1.938 0.375-0.875 0.375-1.688 0.25-1.875-0.125-0.125-0.375-0.25-0.75-0.438z"></path></svg>',
        'meneame' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 97.75 97.75" style="enable-background:new 0 0 97.75 97.75;" xml:space="preserve"><g><path d="M48.875,0C21.882,0,0,21.883,0,48.875S21.882,97.75,48.875,97.75S97.75,75.867,97.75,48.875S75.868,0,48.875,0z M33.509,22.451C36.467,20,39.98,18.812,43.711,18.15c5.854-1.037,11.391,0.1,16.748,2.418c2.752,1.189,5.409,2.598,8.252,3.58c0.626,0.219,1.26,0.414,1.921,0.508c1.19,0.166,2.166-0.236,2.949-1.123c1.024-1.156,1.386-2.549,1.384-4.064c0.287-0.018,0.348,0.209,0.439,0.379c0.873,1.605,0.625,4.217-0.562,5.578c-1.24,1.424-2.892,1.678-4.646,1.475c-1.991-0.23-3.887-0.813-5.703-1.678c-3.415-1.629-6.879-3.131-10.59-3.971c-4.645-1.051-9.253-0.867-13.762,0.631c-6.564,2.18-10.016,8.703-8.229,15.398c1.031,3.863,3.204,6.906,6.598,9.057c1.469,0.932,3.088,1.223,4.795,1.201c1.729-0.025,3.413-0.361,5.101-0.682c0.291-0.055,0.576-0.127,1.029,0.008c-1.473,0.914-2.945,1.432-4.498,1.758c-2.274,0.479-4.557,0.479-6.829,0.041c-1.963-0.375-3.574-1.436-4.874-2.912c-2.574-2.928-4.43-6.234-4.979-10.156C27.502,30.221,29.386,25.867,33.509,22.451z M51.924,79.834c-3.04,0.246-6.084,0.385-9.135,0.43c-4.29,0.064-8.596,0.094-12.827-0.619c-6.876-1.158-12.204-4.58-14.791-11.334c-1.387-3.625-1.212-7.399-0.096-11.08c1.675-5.521,4.209-10.587,8.335-14.733c1.068-1.074,2.271-1.998,3.45-2.947c0.115-0.092,0.223-0.236,0.457-0.16c-0.054,0.35-0.252,0.617-0.442,0.889c-3.206,4.574-5.952,9.396-8.023,14.598c-1.442,3.623-1.788,7.324-0.836,11.109c1.18,4.686,4.299,7.578,8.695,9.279c3.188,1.231,6.512,1.823,9.883,2.223c4.687,0.553,9.39,0.924,14.085,1.379c0.451,0.043,0.898,0.168,1.34,0.287c0.213,0.057,0.485,0.145,0.457,0.432C52.441,79.916,52.132,79.816,51.924,79.834z M54.23,79.592c-0.146,0.199-0.308,0.451-0.604,0.348c-0.265-0.092-0.229-0.371-0.239-0.594c-0.07-1.59,0.188-3.154,0.334-4.729c0.211-2.256,0.59-4.5,0.381-6.785c-0.065-0.723-0.396-1.162-1.039-1.469c-1.896-0.91-3.929-1.205-5.984-1.406c-2.513-0.244-5.038-0.221-7.555-0.373c-0.159-0.008-0.314-0.041-0.472-0.062c4.862-0.799,9.715-1.236,14.604-0.65c2.328,0.279,2.771,0.756,2.826,3.105c0.088,3.719-0.434,7.362-1.486,10.93C54.816,78.5,54.6,79.084,54.23,79.592z M79.469,33.182c-1.754,1.672-3.908,2.707-6.031,3.787c-1.92,0.975-3.898,1.838-5.707,3.023c-1.969,1.289-3.603,2.861-4.146,5.262c-0.44,1.953-0.083,3.885,0.312,5.795c0.863,4.203,2.564,8.117,4.246,12.033c0.869,2.021,1.795,4.02,2.486,6.109c1.115,3.369,0.186,5.967-2.814,7.858c-2.156,1.359-4.572,1.955-7.053,2.351c-1.451,0.229-2.918,0.301-4.421,0.397c-0.313-0.104-0.901,0.246-0.997-0.192c-0.092-0.431,0.522-0.57,0.881-0.722c2.176-0.905,4.371-1.771,6.551-2.674c1.354-0.563,2.678-1.199,3.896-2.028c0.418-0.285,0.804-0.611,1.142-0.988c0.539-0.601,0.668-1.234,0.354-2.021c-1.655-4.148-3.506-8.223-4.957-12.451c-1.17-3.412-2.101-6.869-2.347-10.498c-0.29-4.279,1.191-7.606,4.885-9.897c1.74-1.08,3.611-1.887,5.482-2.695c2.313-1,4.604-2.025,6.633-3.576c3.037-2.316,4.035-5.424,3.775-9.09c-0.117-1.65-0.393-3.27-0.77-4.877c-0.044-0.184-0.292-0.451,0.035-0.594c0.297-0.127,0.453,0.102,0.582,0.336c0.988,1.799,1.762,3.662,2.005,5.729C83.957,27.529,82.217,30.559,79.469,33.182z"/></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
        'blogger' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M21.8,32c5.6,0,10.1-4.5,10.1-10.1l0.1-8.2l-0.1-0.4l-0.3-0.6l-0.5-0.4c-0.6-0.5-3.6,0-4.4-0.7c-0.6-0.5-0.7-1.5-0.8-2.7c-0.3-2.5-0.5-2.6-0.9-3.4c-1.4-3-5.2-5.2-7.8-5.5h-7.1C4.6,0,0,4.6,0,10.1v11.8C0,27.5,4.6,32,10.1,32L21.8,32L21.8,32z M10.3,8.3h5.6c1.1,0,1.9,0.9,1.9,1.9c0,1.1-0.9,1.9-1.9,1.9h-5.6c-1.1,0-1.9-0.9-1.9-1.9C8.3,9.1,9.2,8.3,10.3,8.3z M8.3,21.8c0-1.1,0.9-1.9,1.9-1.9h11.4c1.1,0,1.9,0.9,1.9,1.9c0,1-0.9,1.9-1.9,1.9H10.3C9.2,23.7,8.3,22.8,8.3,21.8z"/></svg>',
        'amazon' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.696 26.643c0.536-0.268 0.946 0.143 0.393 0.857s-5 4.786-12.464 4.786-13.179-5.107-14.929-7.214c-0.482-0.554 0.071-0.804 0.393-0.589 5.232 3.179 13.411 8.411 26.607 2.161zM31.393 24.589c0.268 0.357 0 1.929-0.464 3.071-0.464 1.125-1.143 1.911-1.518 2.214-0.393 0.321-0.679 0.196-0.464-0.268s1.375-3.321 0.911-3.929c-0.464-0.589-2.643-0.304-3.429-0.232-0.768 0.071-0.929 0.143-1-0.018-0.161-0.411 1.554-1.107 2.679-1.25 1.125-0.125 2.929-0.054 3.286 0.411zM24.357 16.679c0 1.964 2.304 3.768 2.304 3.768l-4.054 4c-1.589-1.5-2.786-2.75-2.786-2.75-0.179-0.179-0.321-0.393-0.446-0.589-3.232 5.054-13.107 4.732-13.107-3.089 0-7.286 8.625-8.268 12.107-8.393v-2.268c0-0.482 0.179-2.679-2.536-2.679 0 0-2.714 0-3.875 3.536l-5.25-0.482c0-3.518 3.339-7.446 9.625-7.446 6.268 0 8.018 4.071 8.018 5.875v10.518zM12.357 17.054c0 3.625 6.018 4.482 6.018-1.232v-2.893c-2.411 0.071-6.018 0.75-6.018 4.125z"/></svg>',
        'gmail' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path d="M28.7,4c-0.1,0-0.3,0-0.4,0.1l-12.3,9l-12.3-9C3.6,4,3.5,4,3.3,4C1.5,4,0,5.5,0,7.3v17.3C0,26.5,1.5,28,3.3,28h1.3c0.4,0,0.7-0.3,0.7-0.7V12l10.3,7.3c0.2,0.2,0.5,0.2,0.8,0L26.7,12v15.4c0,0.4,0.3,0.7,0.7,0.7h1.3c1.8,0,3.3-1.5,3.3-3.3V7.3C32,5.5,30.5,4,28.7,4z"/></svg>',
        'aol' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M17.4,12.4c3.4,0,5,2.7,5,4.9s-1.6,4.9-5,4.9c-3.4,0-5-2.7-5-4.9S14.1,12.4,17.4,12.4 M17.4,19.7c1.2,0,2.2-1,2.2-2.3c0-1.4-1-2.3-2.2-2.3s-2.2,1-2.2,2.3C15.2,18.7,16.2,19.7,17.4,19.7 M24,9.7h2.8v12.4H24V9.7z M30.1,18.4c-1,0-1.9,0.8-1.9,1.9s0.8,1.9,1.9,1.9c1,0,1.9-0.8,1.9-1.9C32,19.3,31.2,18.4,30.1,18.4 M7.4,9.7H4.9L0,22.1h3.3L4,20.3h4.3l0.6,1.8h3.3L7.4,9.7z M4.8,17.8l1.3-4.3l1.3,4.3H4.8z"/></svg>',
        'newsvine' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.125 27.375l2.75-2c0-0.125 0-0.188 0-0.25 0-1.25 1-2.313 2.25-2.313s2.313 1.063 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.875-0.125-1.188-0.375l-3.813 2.75v2.25h-2.25v-6.75l-3.875-2.813c-0.375 0.188-0.75 0.313-1.125 0.313-1.25 0-2.313-1.063-2.313-2.313s1.063-2.25 2.313-2.25c1.25 0 2.25 1 2.25 2.25 0 0.125 0 0.25-0.063 0.375l2.813 2.063v-6.75l-3.875-2.813c-0.375 0.188-0.75 0.313-1.125 0.313-1.25 0-2.313-1.063-2.313-2.313s1.063-2.25 2.313-2.25c1.25 0 2.25 1 2.25 2.25 0 0.125 0 0.313-0.063 0.438l2.813 2v-6.313l-3.938-2.875c-0.313 0.188-0.688 0.313-1.063 0.313-1.25 0-2.313-1-2.313-2.25s1.063-2.313 2.313-2.313c1.25 0 2.25 1.063 2.25 2.313 0 0.125 0 0.25-0.063 0.375l2.813 2.063v-5.063h2.25v9.563l2.75-2c0-0.125 0-0.25 0-0.313 0-1.25 1-2.313 2.25-2.313s2.313 1.063 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.813-0.125-1.188-0.313l-3.813 2.75v6.313l2.75-2c0-0.125 0-0.188 0-0.25 0-1.313 1-2.313 2.25-2.313s2.313 1 2.313 2.313c0 1.25-1.063 2.25-2.313 2.25-0.438 0-0.813-0.125-1.188-0.375l-3.813 2.813v6.688z"/></svg>',
        'hackernews' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M22,0c-1.2,2.1-5.7,9.8-5.7,9.8h-0.1c0,0-4.3-7.7-5.6-9.8H3.3l9.6,15.5V32h6.4V15.5L28.7,0H22z"/></svg>',
        'evernote' => '<svg width="32px" height="32px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"> <path d="M10.255 7.26c0 0.319-0.025 0.849-0.337 1.193-0.344 0.317-0.871 0.344-1.188 0.344h-3.365c-0.973 0-1.557 0-1.948 0.057-0.213 0.025-0.473 0.129-0.609 0.181-0.052 0.027-0.052 0-0.025-0.025l7.688-7.88c0.025-0.027 0.052-0.027 0.025 0.025-0.057 0.136-0.156 0.396-0.188 0.609-0.052 0.396-0.052 0.984-0.052 1.964zM17.385 31.083c-0.891-0.583-1.364-1.348-1.552-1.828-0.188-0.463-0.287-0.957-0.287-1.457 0-2.213 1.792-4 4-4.005 0.656 0 1.183 0.525 1.183 1.192 0.005 0.428-0.229 0.823-0.604 1.032-0.136 0.083-0.319 0.135-0.448 0.161-0.131 0.025-0.631 0.077-0.871 0.292-0.26 0.213-0.473 0.557-0.473 0.927 0 0.401 0.156 0.771 0.421 1.036 0.475 0.48 1.105 0.745 1.792 0.745 1.792-0.011 3.245-1.469 3.235-3.265 0-1.62-1.079-3.052-2.5-3.688-0.208-0.104-0.552-0.188-0.869-0.265-0.261-0.057-0.521-0.099-0.787-0.136-1.104-0.129-3.871-1.005-4.052-3.473 0 0-0.819 3.713-2.448 4.724-0.156 0.077-0.371 0.161-0.604 0.213-0.24 0.052-0.5 0.077-0.584 0.077-2.656 0.163-5.468-0.687-7.416-2.708 0 0-1.319-1.083-2-4.135-0.157-0.745-0.475-2.073-0.657-3.319-0.083-0.453-0.109-0.796-0.135-1.115 0-1.301 0.792-2.176 1.792-2.307h5.364c0.921 0 1.453-0.24 1.792-0.557 0.448-0.427 0.552-1.036 0.552-1.751v-5.599c0.131-0.984 1-1.807 2.292-1.807h0.629c0.261 0 0.579 0.025 0.871 0.057 0.208 0.025 0.391 0.077 0.708 0.156 1.604 0.401 1.948 2.041 1.948 2.041s3.025 0.532 4.552 0.797c1.448 0.265 5.025 0.505 5.708 4.14 1.604 8.652 0.636 17.032 0.552 17.032-1.129 8.172-7.864 7.776-7.864 7.776-1.156 0.020-2.292-0.323-3.24-0.985zM23.437 13.708c-0.864-0.083-1.604 0.265-1.864 0.928-0.057 0.135-0.109 0.291-0.084 0.369 0.032 0.083 0.084 0.109 0.136 0.135 0.312 0.163 0.839 0.24 1.604 0.319 0.76 0.077 1.292 0.135 1.631 0.077 0.052 0 0.109-0.025 0.161-0.104 0.052-0.077 0.025-0.239 0.025-0.369-0.083-0.719-0.74-1.251-1.609-1.355z"/></svg>',
        'myspace' => '<svg version="1.1" width="32px" height="32px" inkscape:version="0.48.4 r9939" sodipodi:docname="myspace.svg" xmlns:cc="http://creativecommons.org/ns#" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path id="path14818" inkscape:connector-curvature="0" d="M8.8,23.8l0,2H0v-2c0-2.4,2-4.3,4.4-4.3C6.9,19.5,8.9,21.4,8.8,23.8L8.8,23.8z M8.4,14.8c0,2.2-1.8,4-4,4c-2.2,0-4-1.8-4-4c0-2.2,1.8-4,4-4S8.4,12.6,8.4,14.8z M19.7,23.5l0,2.3H9.6v-2.3c0-2.8,2.3-5,5.1-5C17.5,18.5,19.8,20.8,19.7,23.5L19.7,23.5z M19.3,13.1c0,2.6-2.1,4.6-4.6,4.6c-2.6,0-4.6-2.1-4.6-4.6c0-2.6,2.1-4.6,4.6-4.6C17.2,8.5,19.3,10.5,19.3,13.1L19.3,13.1z M32,23.2l0,2.6H20.5v-2.6c0-3.2,2.7-5.7,5.8-5.7S32,20.1,32,23.2L32,23.2z M31.5,11.4c0,2.9-2.3,5.2-5.2,5.2c-2.9,0-5.2-2.3-5.2-5.2s2.4-5.2,5.2-5.2C29.2,6.2,31.5,8.5,31.5,11.4L31.5,11.4z"/></svg>',
        'mailru' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.8,16c0,2.7-2.2,4.8-4.8,4.8s-4.8-2.2-4.8-4.8s2.2-4.8,4.8-4.8S20.8,13.3,20.8,16 M16,0C7.2,0,0,7.2,0,16s7.2,16,16,16c3.2,0,6.3-1,9-2.8l0.1,0l-2.2-2.5l0,0c-2.1,1.3-4.4,2-6.9,2C9,28.7,3.3,23,3.3,16S9,3.3,16,3.3S28.7,9,28.7,16c0,0.9-0.1,1.8-0.3,2.7c-0.4,1.7-1.6,2.2-2.4,2.1c-0.9-0.1-1.9-0.7-1.9-2.2V16c0-4.5-3.6-8.1-8.1-8.1S7.9,11.5,7.9,16s3.6,8.1,8.1,8.1c2.2,0,4.2-0.9,5.7-2.4c0.9,1.4,2.3,2.3,4,2.4c0.1,0,0.3,0,0.4,0c1.2,0,2.3-0.4,3.2-1.1c1-0.7,1.7-1.8,2.1-3c0.1-0.2,0.2-0.7,0.2-0.7v0c0.2-1,0.3-2,0.3-3.3C32,7.2,24.8,0,16,0"/></svg>',
        'viadeo' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32"><path d="M24,16.1c0-0.1,0-0.1-0.1-0.2c-0.3,0.2-0.6,0.3-0.9,0.4c-0.3,0.1-0.6,0.2-0.9,0.3c-0.3,0.1-0.6,0.2-0.9,0.3c0,0,0,0,0,0.1c0,0,0,0.1,0,0.1c0.4,1.1,0.6,2.2,0.6,3.3c0,0.9-0.1,1.9-0.4,2.8c-0.4,1.4-1.1,2.6-2.1,3.6c-1.4,1.5-3.2,2.3-5.3,2.5c-0.2,0-0.4,0-0.6,0c0,0,0-0.1,0-0.1c0.1-0.1,0.2-0.2,0.3-0.2c2.2-1.6,3.8-3.6,5-6.1c1-2,1.5-4.2,1.6-6.4c0-1.1-0.1-2.2-0.3-3.3c-0.2-1.2-0.6-2.4-1-3.6c0,0-0.1-0.1-0.1-0.2c0-0.2,0-0.3,0-0.3c0,0,0-0.1,0-0.1c-0.1-1-0.3-2-0.6-3c-0.4-1.3-0.9-2.6-1.7-3.8c-0.5-0.8-1.1-1.5-1.8-2.2C15.1,0.1,15,0.1,14.9,0c0,0,0,0.1,0,0.1C15,0.2,15,0.3,15.1,0.4c1.3,2.2,2.4,4.4,3.3,6.8c0.3,0.6,0.5,1.3,0.7,1.9l0.1,0.1c0,0,0,0.1,0,0.3c0,0.3,0,0.7,0,1c0,1.8,0,3.5-0.2,5.3c-0.1,0.8-0.2,1.6-0.3,2.4c-0.2,1-0.4,2-0.7,3c-0.4,1.2-0.8,2.4-1.4,3.5c-0.5,1-1.2,1.9-2,2.7c-0.7,0.7-1.6,1.3-2.6,1.7c-0.1,0-0.2,0.1-0.3,0c-1.3-0.3-2.5-0.8-3.5-1.6c-0.9-0.7-1.6-1.6-2.2-2.6c-0.6-1.1-0.9-2.2-1.1-3.4C5,20.8,5,20,5.1,19.3c0.1-0.9,0.3-1.7,0.7-2.5c0.5-1.2,1.3-2.2,2.3-3.1c0.8-0.7,1.6-1.2,2.5-1.6c0.6-0.2,1.2-0.4,1.9-0.5c0.6-0.1,1.2-0.1,1.7,0c0.7,0.1,1.5,0.2,2.1,0.5c0.1,0,0.1,0,0.2,0.1c0.1-0.5,0.2-0.9,0.3-1.4c0.1-0.4,0.3-0.9,0.5-1.3c-0.1-0.1-0.2-0.1-0.3-0.1c-0.9-0.3-1.9-0.5-2.9-0.5c-1-0.1-2.1,0-3.1,0.2c-1.2,0.2-2.4,0.7-3.4,1.4c-1,0.6-1.9,1.4-2.7,2.3c-1.7,2-2.6,4.4-2.8,7c0,0.8,0,1.5,0.1,2.3c0.1,1.1,0.4,2.1,0.8,3.1c0.7,1.6,1.7,3,3,4.1c0.9,0.9,2,1.5,3.2,2c1.1,0.4,2.3,0.6,3.5,0.7c1.1,0.1,2.2,0,3.3-0.2c1.5-0.3,2.8-0.9,4-1.8c0.9-0.7,1.7-1.5,2.4-2.5c1.4-1.9,2.1-4,2.3-6.3c0.1-0.9,0-1.9-0.1-2.8C24.5,17.6,24.3,16.8,24,16.1z"/><path d="M29.4,3.6c-0.2-0.9-0.6-1.8-1-2.6c-0.1-0.1-0.1-0.2-0.2-0.4C28.1,0.8,28,0.9,28,1c-0.3,0.6-0.7,1.2-1.2,1.6c-0.8,0.7-1.6,1.3-2.6,1.5c-0.1,0-0.2,0-0.3,0.1c-0.8,0.2-1.5,0.5-2.2,0.9c-0.5,0.3-0.9,0.6-1.2,1c-0.6,0.8-0.9,1.7-0.9,2.7c0,0.8,0.3,1.6,0.7,2.3c0,0,0,0.1,0.1,0.1c3.2-0.8,5.7-2.6,7.4-5.6c0,0.1,0,0.1,0,0.2c-0.1,0.3-0.1,0.5-0.3,0.7c-0.3,0.5-0.6,1-1,1.4c-0.7,0.7-1.4,1.4-2.2,2c-1,0.7-1.9,1.4-3,2c-0.1,0-0.2,0.1-0.2,0.2c0.1,0.1,0.3,0.3,0.4,0.4c0.5,0.4,1.1,0.8,1.8,1c0.6,0.2,1.3,0.3,1.9,0.1c0.8-0.1,1.5-0.5,2.1-1c0.6-0.5,1-1.1,1.4-1.8c0.2-0.4,0.4-0.8,0.6-1.2c0.3-0.9,0.5-1.8,0.5-2.7C29.8,5.9,29.7,4.7,29.4,3.6z"/></svg>',
        'line' => '<svg version="1.1" width="32px" height="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M15.2,31C15.2,31,15.2,31,15.2,31c-0.1,0-0.2,0-0.3-0.1l0,0c-0.3-0.2-0.2-0.8-0.1-1.5c0.1-0.4,0.2-0.8,0.2-1.2c0-0.2,0-0.4,0-0.5l0,0c-0.1-0.6-0.6-1.1-1.2-1.1h0c-0.2,0-0.4,0-0.5-0.1c-1.9-0.3-3.7-0.8-5.3-1.6l0.1,0c-0.9-0.4-1.6-0.8-2.3-1.3l0.1,0c-0.7-0.5-1.4-1-1.9-1.6l0,0c-0.6-0.5-1.1-1.1-1.6-1.8l0,0c-0.4-0.6-0.8-1.2-1.2-1.9l0-0.1c-0.6-1.3-1-2.9-1-4.5c0-0.9,0.1-1.8,0.3-2.7l0,0.1c0.2-0.9,0.6-1.7,1-2.5l0,0.1C1.7,8,2.2,7.3,2.7,6.7l0,0C3.3,6,4,5.4,4.7,4.8l0,0C5.4,4.2,6.2,3.7,7,3.3l0.1,0c0.8-0.4,1.7-0.8,2.6-1.1l0.1,0c0.8-0.3,1.9-0.6,2.9-0.7l0.1,0C13.7,1.1,14.9,1,16,1s2.3,0.1,3.3,0.3l-0.1,0c1.2,0.2,2.2,0.4,3.1,0.8l-0.1,0c1.1,0.4,2,0.8,2.8,1.2l-0.1,0c0.9,0.5,1.7,1,2.4,1.6l0,0C28,5.4,28.7,6,29.2,6.7l0,0c0.5,0.6,1,1.3,1.4,2.1l0,0.1c0.4,0.7,0.7,1.5,0.9,2.3l0,0.1c0.2,0.8,0.3,1.7,0.3,2.6c0,1.3-0.2,2.5-0.7,3.6l0-0.1c-0.5,1.2-1,2.3-1.8,3.2l0,0c-0.1,0.1-0.2,0.3-0.3,0.4l0,0l0,0c-0.5,0.6-1.1,1.2-1.7,1.7l0,0c-2.1,1.9-4.4,3.8-6.9,5.4l-0.2,0.1c-0.9,0.6-1.9,1.3-3,1.9l-0.2,0.1c-0.3,0.2-0.7,0.4-1.1,0.5l-0.1,0C15.8,30.9,15.5,31,15.2,31L15.2,31L15.2,31z M22.7,10.1c-0.5,0-0.8,0.4-0.8,0.8v6.2c0,0.5,0.4,0.8,0.8,0.8h3.2c0.5,0,0.8-0.4,0.8-0.8V17c0-0.5-0.4-0.8-0.8-0.8h-2.3v-1.3h2.3c0.5,0,0.8-0.4,0.8-0.8V14c0-0.5-0.4-0.8-0.8-0.8h-2.3v-1.3h2.3c0.5,0,0.8-0.4,0.8-0.8v-0.1c0-0.5-0.4-0.8-0.8-0.8L22.7,10.1z M15.2,10.1c-0.5,0-0.8,0.4-0.8,0.8v6.2c0,0.5,0.4,0.8,0.8,0.8h0.1c0.5,0,0.8-0.4,0.8-0.8v-3.7l3,4.1c0,0,0,0.1,0.1,0.1l0,0c0.1,0.1,0.2,0.2,0.3,0.2l0,0c0.1,0,0.2,0.1,0.3,0.1h0h0.1c0.1,0,0.3,0,0.4-0.1l0,0c0.1,0,0.1-0.1,0.2-0.2v0c0.1-0.1,0.2-0.4,0.2-0.6v0v-6.2c0-0.5-0.4-0.8-0.8-0.8h-0.1c-0.5,0-0.8,0.4-0.8,0.8v3.6l-3-4C15.8,10.2,15.6,10.1,15.2,10.1L15.2,10.1z M12.3,10.1c-0.5,0-0.8,0.4-0.8,0.8v6.2c0,0.5,0.4,0.8,0.8,0.8h0.1c0.5,0,0.8-0.4,0.8-0.8v-6.2C13.2,10.4,12.8,10.1,12.3,10.1L12.3,10.1z M6.7,10.1c-0.5,0-0.8,0.4-0.8,0.8v6.2c0,0.5,0.4,0.8,0.8,0.8h3.2c0.5,0,0.8-0.4,0.8-0.8V17c0-0.5-0.4-0.8-0.8-0.8H7.6v-5.3C7.6,10.4,7.2,10.1,6.7,10.1L6.7,10.1z"/></svg>',
        'flipboard' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M4.313 2.313v23.375h7.813v-7.813h7.75v-7.75h7.813v-7.813z"></path></svg>',
        'comments' => '<svg width="38" height="32" viewBox="0 0 38 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M37.7,13.3c0,2.4-0.8,4.7-2.5,6.7s-3.9,3.6-6.8,4.8c-2.9,1.2-6.1,1.8-9.4,1.8c-0.9,0-2-0.1-3-0.1c-2.8,2.4-6,4.1-9.6,5c-0.7,0.1-1.5,0.3-2.3,0.4c-0.3,0-0.5,0-0.7-0.2c-0.2-0.1-0.3-0.3-0.4-0.6l0,0C3,31.1,3,31.1,3,30.9c0-0.1,0-0.1,0-0.1c0-0.1,0.1-0.1,0.1-0.2l0.1-0.2l0.1-0.1L3.6,30c0.1-0.1,0.3-0.4,0.6-0.7c0.4-0.4,0.6-0.6,0.7-0.7c0.1-0.2,0.4-0.4,0.7-0.9c0.3-0.4,0.5-0.7,0.7-1c0.2-0.4,0.4-0.7,0.6-1.2c0.2-0.5,0.4-1,0.6-1.6c-2.2-1.2-3.9-2.8-5.2-4.6s-1.9-3.7-1.9-5.8c0-1.8,0.5-3.5,1.5-5.2c1-1.7,2.3-3.1,4-4.2c1.7-1.2,3.6-2.2,6-2.8C14,0.4,16.4,0,19,0c3.4,0,6.5,0.6,9.4,1.8c2.8,1.2,5.1,2.8,6.8,4.8S37.7,10.9,37.7,13.3z"/></svg>',
        'yummly' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path id="svg_8" d="M28.5,23.3c0-0.2-0.2-0.3-0.3-0.3c-0.3-0.1-0.5,0-1.4-0.4c-0.6-0.3-3.8-1.8-8.1-2.3l3.1-17.7c0.1-0.8,0.1-1.4-0.1-1.8c-0.3-0.6-1.2-0.8-2-0.6c-0.8,0.1-1.3,0.3-1.4,0.4c-0.1,0.1-0.2,0.2-0.2,0.4c0,0.3,0.3,0.6,0.1,1.8c0,0.3-1.1,5.9-1.9,10.8c-2.3,1.4-5.3,2-5.9,1.2c-0.3-0.4-0.2-1.2,0.1-2.4c0.1-0.2,1.4-5.3,1.7-6.8c0.8-2.8,0.2-5.3-2.7-5.6c-2.5-0.2-4.9,1.2-5.6,2c-0.5,0.5-0.3,1.2,0.1,2c0.3,0.6,0.9,1.1,1,1.1c0.1,0.1,0.3,0.1,0.4,0c0.9-1,2.4-1.6,2.9-1.2c0.4,0.4,0.3,1.1,0.1,1.8c0,0-1.6,6.1-2.3,8.6c-0.4,1.8,0,3.6,1.4,4.4c1,0.6,2.5,0.5,3.7,0.4c2.6-0.3,4.1-1.4,4.3-1.6c-0.3,1.6-0.4,2.7-0.4,2.7s-2.9,0.2-5.3,1.7c-3.1,1.8-4.4,6.2-2.4,8.4s5.5,1.4,7,0.4c1.4-1,3.1-2.9,4-7.3c4.8,0.2,5.9,2.7,8,2.8C27.6,26.2,28.6,24.9,28.5,23.3z M12.3,27.7c-0.6,0.4-1.4,0.4-1.8,0c-0.4-0.5-0.5-3.3,3.9-4.1C14.4,23.4,13.6,26.8,12.3,27.7z"/></svg>',
        'sms' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24 10.688v-2.688h-16v2.688h16zM18.688 18.688v-2.688h-10.688v2.688h10.688zM8 12v2.688h16v-2.688h-16zM26.688 2.688c1.438 0 2.625 1.188 2.625 2.625v16c0 1.438-1.188 2.688-2.625 2.688h-18.688l-5.313 5.313v-24c0-1.438 1.188-2.625 2.625-2.625h21.375z"></path></svg>',
        'plus' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6h-9.5v9.4c0,0.6-0.2,1.2-0.6,1.6s-1,0.6-1.6,0.6h-4.3c-0.6,0-1.2-0.2-1.6-0.6c-0.4-0.4-0.6-1-0.6-1.6v-9.4H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h9.5V2.1c0-0.6,0.2-1.1,0.6-1.5c0.4-0.5,1-0.6,1.6-0.6h4.3c0.6,0,1.2,0.2,1.6,0.6c0.4,0.4,0.6,0.9,0.6,1.5v9.5h9.5c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'minus' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h27.7c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'close' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32,25.7c0,0.7-0.3,1.3-0.8,1.8l-3.7,3.7c-0.5,0.5-1.1,0.8-1.9,0.8c-0.7,0-1.3-0.3-1.8-0.8L16,23.3l-7.9,7.9C7.6,31.7,7,32,6.3,32c-0.8,0-1.4-0.3-1.9-0.8l-3.7-3.7C0.3,27.1,0,26.4,0,25.7c0-0.8,0.3-1.3,0.8-1.9L8.7,16L0.8,8C0.3,7.6,0,6.9,0,6.3c0-0.8,0.3-1.3,0.8-1.9l3.7-3.6C4.9,0.2,5.6,0,6.3,0C7,0,7.6,0.2,8.1,0.8L16,8.7l7.9-7.9C24.4,0.2,25,0,25.7,0c0.8,0,1.4,0.2,1.9,0.8l3.7,3.6C31.7,4.9,32,5.5,32,6.3c0,0.7-0.3,1.3-0.8,1.8L23.3,16l7.9,7.9C31.7,24.4,32,25,32,25.7z"/></svg>',
        'share-alt' => '<svg height="32" viewBox="0 0 36 32" width="36" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M35.9,11.6c0,0.4-0.1,0.6-0.4,0.9L25.3,22.7C25.1,23,24.7,23,24.4,23c-0.4,0-0.6-0.1-0.8-0.4c-0.3-0.3-0.4-0.6-0.4-0.9v-5.1h-4.5c-1.3,0-2.5,0.1-3.5,0.1c-1.1,0.1-2,0.2-3.1,0.4c-1.1,0.2-1.9,0.5-2.7,0.8c-0.8,0.4-1.5,0.8-2.1,1.4s-1.2,1.3-1.6,2s-0.8,1.7-1,2.7c-0.2,1.1-0.4,2.3-0.4,3.6c0,0.7,0.1,1.5,0.1,2.5c0,0.1,0,0.3,0,0.5c0.1,0.2,0.1,0.4,0.1,0.5c0,0.2-0.1,0.4-0.1,0.6C4.3,31.9,4.1,32,3.9,32s-0.4-0.1-0.6-0.3c-0.1-0.1-0.2-0.3-0.3-0.5c-0.1-0.1-0.1-0.4-0.3-0.6c-0.1-0.3-0.1-0.4-0.2-0.5c-1.7-3.8-2.5-6.8-2.5-9c0-2.7,0.4-4.9,1.1-6.7c2.2-5.4,8-8.1,17.5-8.1h4.5V1.3c0-0.4,0.1-0.7,0.4-0.9C23.7,0.1,24,0,24.4,0c0.4,0,0.7,0.1,0.9,0.4l10.3,10.2C35.8,10.9,35.9,11.2,35.9,11.6z"/></svg>',
        'share-alt-square' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M26.7,22.2c0-1.2-0.4-2.3-1.3-3.1c-0.8-0.9-1.9-1.3-3.1-1.3c-1.2,0-2.1,0.4-3,1.2l-5-2.5c0.1-0.2,0.1-0.4,0.1-0.5s0-0.3-0.1-0.5l5-2.5c0.9,0.8,1.8,1.2,3,1.2c1.2,0,2.3-0.4,3.1-1.3c0.9-0.9,1.3-2,1.3-3.1c0-1.2-0.4-2.3-1.3-3.1c-0.8-0.9-1.9-1.3-3.1-1.3c-1.2,0-2.3,0.4-3.1,1.3c-0.9,0.8-1.3,1.9-1.3,3.1c0,0.1,0,0.2,0.1,0.4l-5,2.5c-0.9-0.7-1.9-1.2-3-1.2c-1.2,0-2.3,0.4-3.1,1.3c-0.9,0.9-1.3,1.9-1.3,3.1s0.4,2.3,1.3,3.1c0.8,0.9,1.9,1.3,3.1,1.3c1.1,0,2.1-0.4,3-1.2l5,2.5c-0.1,0.2-0.1,0.4-0.1,0.4c0,1.2,0.4,2.3,1.3,3.1c0.9,0.9,2,1.3,3.1,1.3c1.2,0,2.3-0.4,3.1-1.3C26.2,24.5,26.7,23.5,26.7,22.2z M32,6v20c0,1.7-0.6,3.1-1.8,4.2C29.1,31.4,27.7,32,26,32H6c-1.7,0-3.1-0.6-4.2-1.8C0.6,29.1,0,27.7,0,26V6c0-1.7,0.6-3.1,1.8-4.2S4.3,0,6,0h20c1.7,0,3.1,0.6,4.2,1.8C31.4,2.9,32,4.3,32,6z"/></svg>',
        'share' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.4,18.7c1.8,0,3.4,0.6,4.7,1.9c1.3,1.3,1.9,2.9,1.9,4.7c0,1.8-0.6,3.4-1.9,4.7c-1.3,1.3-2.9,1.9-4.7,1.9c-1.8,0-3.4-0.6-4.7-1.9c-1.3-1.3-1.9-2.9-1.9-4.7c0-0.1,0-0.4,0-0.7l-7.5-3.7c-1.2,1.2-2.8,1.8-4.5,1.8c-1.8,0-3.4-0.6-4.7-1.9C0.6,19.4,0,17.8,0,16s0.6-3.4,1.9-4.7s2.9-1.9,4.7-1.9c1.8,0,3.3,0.6,4.5,1.8l7.5-3.7c0-0.3,0-0.6,0-0.7c0-1.8,0.6-3.4,1.9-4.7C21.9,0.6,23.5,0,25.4,0c1.8,0,3.4,0.6,4.7,1.9C31.4,3.2,32,4.8,32,6.6s-0.6,3.4-1.9,4.7c-1.3,1.3-2.9,1.9-4.7,1.9c-1.8,0-3.3-0.6-4.5-1.8l-7.5,3.7c0,0.3,0,0.6,0,0.7c0,0.1,0,0.4,0,0.7l7.5,3.7C22.1,19.3,23.6,18.7,25.4,18.7z"/></svg>',
        'share-tiny' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24.9,21.4c1.5,0,2.7,0.5,3.8,1.5c1,1,1.6,2.3,1.6,3.8c0,1.5-0.6,2.7-1.6,3.8c-1,1-2.3,1.5-3.8,1.5c-1.5,0-2.7-0.5-3.8-1.5c-1-1-1.6-2.3-1.6-3.8c0-0.1,0-0.3,0.1-0.6c0-0.1,0-0.3,0-0.4l-9.3-5.6c-1,0.8-2.1,1.2-3.3,1.2c-1.5,0-2.7-0.6-3.8-1.6S1.7,17.5,1.7,16s0.6-2.7,1.6-3.8s2.3-1.6,3.8-1.6c1.3,0,2.4,0.3,3.3,1.1l9.3-5.6c0-0.1,0-0.3,0-0.4c-0.1-0.2-0.1-0.3-0.1-0.5c0-1.5,0.6-2.7,1.6-3.8c1-1,2.3-1.5,3.8-1.5c1.5,0,2.7,0.5,3.8,1.5c1,1,1.6,2.3,1.6,3.8c0,1.5-0.6,2.8-1.6,3.8s-2.3,1.5-3.8,1.5c-1.3,0-2.3-0.3-3.2-1.1l-9.3,5.6c0,0.1,0.1,0.5,0.1,0.9c0,0.3-0.1,0.7-0.1,0.8l9.3,5.6C22.5,21.7,23.7,21.4,24.9,21.4"/></svg>',
        'share-outline' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M26.7,21.3c-1.6,0-3.1,0.8-4,1.9l-9.8-4.9c0.3-0.8,0.4-1.5,0.4-2.3s-0.1-1.6-0.4-2.3l9.8-4.9c0.9,1.1,2.4,1.9,4,1.9c2.9,0,5.3-2.4,5.3-5.4S29.6,0,26.7,0s-5.4,2.4-5.4,5.3c0,0.4,0.1,0.8,0.1,1.1l-9.9,5l0,0c-1.2-1.3-2.9-2.1-4.8-2.1C3,9.3,0,12.3,0,16s3,6.7,6.7,6.7c1.9,0,3.6-0.8,4.8-2.1l0,0l9.9,5c-0.1,0.4-0.1,0.8-0.1,1.1c0,2.9,2.4,5.3,5.4,5.3s5.3-2.4,5.3-5.3S29.6,21.3,26.7,21.3z M26.7,2.7c1.4,0,2.6,1.2,2.6,2.6c0,1.5-1.2,2.7-2.6,2.7C25.2,8,24,6.8,24,5.3C24,3.9,25.2,2.7,26.7,2.7z M6.7,20c-2.3,0-4-1.8-4-4s1.8-4,4-4c2.2,0,4,1.8,4,4S8.9,20,6.7,20z M26.7,29.3c-1.5,0-2.7-1.2-2.7-2.6c0-1.5,1.2-2.7,2.7-2.7c1.4,0,2.6,1.2,2.6,2.7C29.3,28.1,28.1,29.3,26.7,29.3z"/></svg>',
        'ellipsis-h' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.8,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.5,0.4-1,0.6-1.6,0.6H2.1c-0.6,0-1.1-0.2-1.5-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.5-0.6h4.4c0.6,0,1.1,0.2,1.6,0.6C8.5,12.7,8.8,13.2,8.8,13.8z M20.4,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.6,0.6h-4.3c-0.6,0-1.2-0.2-1.6-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.4-0.4,1-0.6,1.6-0.6h4.3c0.6,0,1.2,0.2,1.6,0.6C20.1,12.7,20.4,13.2,20.4,13.8z M32,13.8v4.4c0,0.6-0.2,1.1-0.6,1.6c-0.4,0.4-1,0.6-1.5,0.6h-4.4c-0.6,0-1.1-0.2-1.6-0.6c-0.4-0.5-0.6-1-0.6-1.6v-4.4c0-0.6,0.2-1.1,0.6-1.5c0.5-0.4,1-0.6,1.6-0.6h4.4c0.6,0,1.1,0.2,1.5,0.6C31.8,12.7,32,13.2,32,13.8z"/></svg>',
        'viber' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M27.7,3.1C27,2.4,23.7,0.1,16.6,0c0,0-8.4-0.5-12.6,3.3c-2.3,2.3-3.1,5.6-3.2,9.8S0.7,25,8.2,27.1h0l0,3.2c0,0,0,1.3,0.8,1.6c1,0.3,1.7-0.7,2.6-1.7c0.5-0.6,1.3-1.4,1.9-2.1c0.8,0.1,1.7,0.1,2.7,0.1c2.4,0,4.8-0.3,7.1-0.9l-0.2,0c1-0.3,6.9-1.1,7.9-8.9C31.9,10.5,30.4,5.4,27.7,3.1z M28.6,17.9c-0.8,6.5-5.6,6.9-6.4,7.2c-1.9,0.5-4.1,0.8-6.4,0.8c-0.6,0-1.3,0-1.9-0.1l0.1,0c0,0-3.2,3.9-4.3,4.9C9.4,31.1,9,31.1,9,30.4c0-0.4,0-5.4,0-5.4c-6.4-1.8-6-8.4-5.9-11.9C3.2,9.7,3.9,6.9,5.8,5c3.5-3.2,10.6-2.7,10.6-2.7c6.1,0,9,1.9,9.6,2.5C28.3,6.7,29.5,11.2,28.6,17.9L28.6,17.9z M19.9,12.9L19.9,12.9c0,0.2-0.2,0.4-0.4,0.4c-0.2,0-0.4-0.2-0.4-0.4v0c0-0.1,0-0.1,0-0.2c0-1.1-0.9-1.9-1.9-1.9c0,0-0.1,0-0.1,0h0c-0.2,0-0.4-0.2-0.4-0.4c0-0.2,0.2-0.4,0.4-0.4h0h0c0,0,0.1,0,0.1,0c1.5,0,2.7,1.2,2.7,2.7C19.9,12.8,19.9,12.8,19.9,12.9L19.9,12.9L19.9,12.9z M21.2,13.6c0.1-2.7-1.6-4.7-4.7-5c-0.2,0-0.4-0.2-0.4-0.4c0-0.2,0.2-0.4,0.4-0.4c0,0,0,0,0,0h0h0c3,0,5.5,2.5,5.5,5.5c0,0.1,0,0.2,0,0.3l0,0c0,0.2-0.2,0.4-0.4,0.4C21.4,14,21.2,13.8,21.2,13.6C21.2,13.6,21.2,13.6,21.2,13.6L21.2,13.6z M24.1,14.4L24.1,14.4c0,0.2-0.2,0.4-0.4,0.4s-0.4-0.2-0.4-0.4c0-5.1-3.4-7.9-7.5-7.9c-0.2,0-0.4-0.2-0.4-0.4c0-0.2,0.2-0.4,0.4-0.4C20.4,5.8,24.1,8.9,24.1,14.4L24.1,14.4z M23.4,20.6L23.4,20.6c-0.7,1.2-1.9,2.5-3.2,2.1l0,0c-2.4-0.9-4.6-2.1-6.4-3.6l0.1,0c-1-0.8-1.9-1.7-2.6-2.6l0,0c-0.7-0.9-1.3-1.8-1.9-2.8l-0.1-0.1c-0.6-1-1.2-2.1-1.6-3.3l0-0.1C7.2,8.8,8.5,7.5,9.7,6.8h0c0.2-0.1,0.4-0.2,0.6-0.2c0.4,0,0.7,0.2,0.9,0.4l0,0c0,0,0.8,0.9,1.1,1.4c0.3,0.4,0.7,1.1,0.9,1.5c0.1,0.2,0.2,0.4,0.2,0.7c0,0.4-0.2,0.7-0.4,1l0,0l-0.7,0.6c-0.2,0.2-0.3,0.5-0.3,0.8c0,0,0,0.1,0,0.1v0c0.8,2.5,2.7,4.5,5.2,5.3l0.1,0c0,0,0.1,0,0.1,0c0.3,0,0.6-0.1,0.8-0.3l0.6-0.7c0.2-0.3,0.6-0.4,1-0.4c0.3,0,0.5,0.1,0.7,0.2l0,0c1.1,0.6,2,1.3,2.9,2.1l0,0c0.3,0.2,0.4,0.5,0.4,0.9C23.6,20.2,23.5,20.4,23.4,20.6L23.4,20.6L23.4,20.6z"/></svg>',
        'telegram' => '<svg width="28" height="32" viewBox="0 0 28 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M27.919 6.162l-4.225 19.925c-0.319 1.406-1.15 1.756-2.331 1.094l-6.438-4.744-3.106 2.988c-0.344 0.344-0.631 0.631-1.294 0.631l0.463-6.556 11.931-10.781c0.519-0.463-0.113-0.719-0.806-0.256l-14.75 9.287-6.35-1.988c-1.381-0.431-1.406-1.381 0.288-2.044l24.837-9.569c1.15-0.431 2.156 0.256 1.781 2.013z"></path></svg>',
        'prev' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.9,5.5L15.4,16l10.6,10.5c0.2,0.3,0.3,0.6,0.3,0.9c0,0.3-0.1,0.7-0.3,0.9l-3.3,3.3C22.4,31.9,22,32,21.7,32c-0.3,0-0.6-0.1-0.8-0.3L6.1,16.9c-0.3-0.3-0.4-0.6-0.4-0.9c0-0.3,0.1-0.7,0.4-0.9L20.9,0.4C21.1,0.1,21.3,0,21.7,0c0.3,0,0.7,0.1,0.9,0.4l3.3,3.3c0.2,0.3,0.3,0.6,0.3,0.9C26.3,4.9,26.1,5.2,25.9,5.5z"/></svg>',
        'next' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.9,16.9L11.1,31.7c-0.2,0.2-0.5,0.3-0.8,0.3s-0.7-0.1-0.9-0.3l-3.3-3.3c-0.2-0.2-0.3-0.6-0.3-0.9c0-0.3,0.1-0.6,0.3-0.9L16.6,16L6.1,5.5C5.9,5.2,5.7,4.9,5.7,4.6c0-0.3,0.1-0.6,0.3-0.9l3.3-3.3C9.6,0.1,10,0,10.3,0s0.6,0.1,0.8,0.4l14.7,14.7c0.3,0.2,0.4,0.6,0.4,0.9C26.3,16.4,26.1,16.7,25.9,16.9z"/></svg>',
        'clock' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M18.7,8.6V18c0,0.2-0.1,0.4-0.2,0.5s-0.3,0.2-0.5,0.2h-6.6c-0.2,0-0.4-0.1-0.5-0.2c-0.1-0.1-0.1-0.3-0.1-0.5v-1.3c0-0.2,0.1-0.4,0.1-0.4c0.1-0.1,0.3-0.2,0.5-0.2H16V8.6c0-0.1,0.1-0.3,0.2-0.4C16.3,8,16.4,8,16.7,8H18c0.2,0,0.4,0.1,0.5,0.2C18.6,8.3,18.7,8.5,18.7,8.6z M27.3,16c0-2-0.5-3.9-1.5-5.7c-1-1.8-2.4-3.1-4.2-4.2C19.9,5.2,18,4.7,16,4.7s-3.9,0.5-5.7,1.5c-1.8,1-3.1,2.4-4.2,4.2C5.2,12.1,4.7,14,4.7,16s0.5,3.9,1.5,5.7c1,1.8,2.4,3.1,4.2,4.2c1.8,0.9,3.7,1.5,5.7,1.5s3.9-0.5,5.7-1.5c1.8-1,3.1-2.4,4.2-4.2C26.8,19.9,27.3,18,27.3,16z M32,16c0,2.9-0.7,5.6-2.1,8c-1.5,2.5-3.4,4.4-5.8,5.8c-2.4,1.5-5.1,2.1-8,2.1s-5.6-0.7-8-2.1c-2.5-1.5-4.4-3.4-5.8-5.8C0.7,21.6,0,18.9,0,16s0.7-5.6,2.1-8C3.6,5.5,5.5,3.6,8,2.1C10.4,0.7,13.1,0,16,0s5.6,0.7,8,2.1c2.5,1.5,4.4,3.4,5.8,5.8C31.3,10.4,32,13.1,32,16z"/></svg>',
        'youtube' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.688 9.625c0 0-0.313-2.25-1.25-3.188-1.25-1.313-2.625-1.313-3.25-1.375-4.438-0.313-11.188-0.313-11.188-0.313v0c0 0-6.75 0-11.188 0.313-0.625 0.063-2 0.063-3.25 1.375-0.938 0.938-1.25 3.188-1.25 3.188s-0.313 2.563-0.313 5.125v2.438c0 2.625 0.313 5.188 0.313 5.188s0.313 2.188 1.25 3.188c1.25 1.25 2.875 1.25 3.563 1.375 2.563 0.25 10.875 0.313 10.875 0.313s6.75 0 11.188-0.313c0.625-0.063 2-0.125 3.25-1.375 0.938-1 1.25-3.188 1.25-3.188s0.313-2.563 0.313-5.188v-2.438c0-2.563-0.313-5.125-0.313-5.125zM20.313 16.25v0l-7.563 3.938v-9l8.625 4.5z"></path></svg>',
        'skype' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 300 300" style="enable-background:new 0 0 300 300;" xml:space="preserve"><g id="XMLID_818_"><path id="XMLID_819_" d="M289.391,181.848c2.133-9.755,3.268-19.881,3.268-30.273c0-77.917-63.166-141.084-141.086-141.084c-8.226,0-16.286,0.711-24.128,2.064C114.836,4.611,99.918,0,83.916,0C38.728,0,2.097,36.635,2.097,81.816c0,15.104,4.109,29.24,11.246,41.385c-1.871,9.166-2.854,18.653-2.854,28.373c0,77.917,63.165,141.084,141.084,141.084c8.826,0,17.459-0.817,25.834-2.367c11.518,6.19,24.688,9.709,38.678,9.709c45.189,0,81.818-36.631,81.818-81.816C297.903,205.127,294.83,192.797,289.391,181.848z M223.932,218.998c-6.527,9.236-16.17,16.555-28.664,21.749c-12.373,5.143-27.205,7.751-44.088,7.751c-20.264,0-37.253-3.564-50.513-10.598c-9.479-5.121-17.296-12.056-23.229-20.613c-5.993-8.645-9.033-17.223-9.033-25.494c0-5.17,1.98-9.652,5.886-13.32c3.865-3.636,8.818-5.478,14.724-5.478c4.848,0,9.029,1.456,12.429,4.328c3.247,2.752,6.034,6.824,8.273,12.083c2.5,5.726,5.226,10.561,8.105,14.369c2.767,3.663,6.748,6.742,11.832,9.145c5.115,2.422,12.01,3.649,20.491,3.649c11.663,0,21.226-2.49,28.419-7.402c7.025-4.797,10.441-10.555,10.441-17.604c0-5.57-1.783-9.947-5.449-13.382c-3.84-3.591-8.904-6.386-15.055-8.303c-6.412-1.999-15.117-4.155-25.884-6.409c-14.586-3.124-26.985-6.83-36.86-11.019c-0.038-0.015-0.077-0.031-0.115-0.048c-10.117-4.303-18.271-10.27-24.236-17.736c-6.059-7.582-9.129-17.094-9.129-28.275c0-10.658,3.223-20.265,9.58-28.552c6.309-8.229,15.523-14.624,27.385-19.012c11.709-4.33,25.637-6.524,41.396-6.524c12.6,0,23.678,1.455,32.924,4.33c9.299,2.896,17.139,6.807,23.299,11.619c6.205,4.848,10.82,10.035,13.719,15.422c2.928,5.441,4.412,10.856,4.412,16.094c0,5.041-1.947,9.622-5.787,13.615c-3.863,4.016-8.738,6.055-14.49,6.055c-5.225,0-9.314-1.275-12.152-3.789c-2.641-2.334-5.379-5.973-8.42-11.209c-3.518-6.684-7.775-11.953-12.66-15.666c-4.74-3.606-12.666-5.437-23.555-5.437c-10.113,0-18.338,2.03-24.445,6.034c-5.885,3.858-8.744,8.282-8.744,13.523c0,3.215,0.92,5.901,2.813,8.213c2.005,2.449,4.833,4.6,8.408,6.388c3.708,1.864,7.529,3.345,11.357,4.402c3.921,1.088,10.5,2.7,19.522,4.784c9.506,2.041,18.359,4.289,26.418,6.695c1.619,0.483,3.219,0.972,4.771,1.468c9.395,3.007,17.514,6.716,24.135,11.022c6.758,4.401,12.109,10.053,15.906,16.8c3.807,6.771,5.736,15.132,5.736,24.844C233.803,199.135,230.481,209.727,223.932,218.998z"/></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>',
        'messenger' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M0,15.5C0,6.6,7,0,16,0s16,6.6,16,15.5S25,31,16,31c-1.6,0-3.2-0.2-4.6-0.6c-0.3-0.1-0.6-0.1-0.9,0.1l-3.2,1.4c-0.6,0.3-1.4,0-1.7-0.6c-0.1-0.2-0.1-0.3-0.1-0.5l-0.1-2.9c0-0.3-0.2-0.7-0.4-0.9C1.8,24.1-0.1,19.9,0,15.5z M11.1,12.6l-4.7,7.5c-0.5,0.7,0.4,1.5,1.1,1l5.1-3.8c0.3-0.3,0.8-0.3,1.2,0l3.7,2.8c1.1,0.8,2.7,0.5,3.5-0.6l4.7-7.5c0.5-0.7-0.4-1.5-1.1-1l-5.1,3.8c-0.3,0.3-0.8,0.3-1.1,0L14.6,12c-1.1-0.8-2.6-0.6-3.4,0.5C11.2,12.5,11.1,12.5,11.1,12.6z"/></svg>',
        'kakaotalk' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11.6,15.1h1.8l-0.9-2.7L11.6,15.1z M15.9,1.3C7.1,1.3,0,6.9,0,13.8c0,4.5,2.9,8.4,7.5,10.7c-0.3,0.9-1.6,5.4-1.6,5.7c0,0,0,0.3,0.1,0.4c0.2,0.1,0.4,0,0.4,0c0.4-0.1,5.8-3.9,6.7-4.5c1,0.1,1.9,0.1,2.9,0.1c8.7,0,15.9-5.6,15.9-12.6C31.8,6.9,24.7,1.3,15.9,1.3z M8,17.4c0,0.4-0.4,0.9-0.9,0.9c-0.5,0-0.9-0.4-0.9-0.9v-5.5H4.8c-0.5,0-0.9-0.4-0.9-0.9c0-0.4,0.4-0.9,0.9-0.9h4.7c0.5,0,0.9,0.4,0.9,0.9c0,0.5-0.4,0.9-0.9,0.9H8L8,17.4L8,17.4z M15.7,18.1c-0.1,0.1-0.4,0.2-0.6,0.2c-0.4,0-0.6-0.2-0.7-0.4l-0.5-1.2h-2.8l-0.4,1.2c-0.1,0.3-0.4,0.4-0.8,0.4c-0.3,0-0.4-0.1-0.6-0.2c-0.3-0.1-0.5-0.4-0.3-1.2l2.2-5.8c0.1-0.4,0.6-0.9,1.2-0.9c0.6,0,1.1,0.5,1.2,0.9l2.2,5.8C16.2,17.7,16,18,15.7,18.1z M20.4,18.1h-3c-0.4,0-0.9-0.4-0.9-0.9V11c0-0.4,0.4-0.9,1-0.9c0.4,0,0.9,0.4,0.9,0.9v5.4h2c0.5,0,0.9,0.4,0.9,0.9C21.3,17.7,20.8,18.1,20.4,18.1z M27.6,17.4c0,0.3-0.1,0.5-0.3,0.6c-0.2,0.2-0.3,0.2-0.6,0.2c-0.3,0-0.6-0.2-0.7-0.4l-2.2-2.9l-0.3,0.3v2c0,0.5-0.4,1-0.9,1s-1-0.4-1-1V11c0-0.4,0.4-0.9,1-0.9c0.4,0,0.9,0.4,0.9,0.9v2l2.5-2.6c0.1-0.1,0.3-0.2,0.5-0.2s0.4,0.1,0.6,0.2c0.1,0.2,0.3,0.4,0.3,0.6c0,0.3-0.1,0.4-0.3,0.6l-2.1,2.1l2.2,3C27.5,16.9,27.6,17.2,27.6,17.4z"/></svg>',
        'livejournal' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11 3.125c0 0 0 0 0 0s0 0 0 0 0 0 0 0zM16.938 1.875c-2.125 0-4.125 0.438-5.938 1.25 0.125 0.063 0.188 0.125 0.313 0.25 0.313 0.313 0.625 0.625 0.938 0.938 0.063 0.063 0.063 0.063 0.063 0.063l10.75 10.75c-3.313 1.938-5.875 4.563-7.75 8l-10.813-10.813c-0.063-0.063-0.063-0.063-0.125-0.125-0.313-0.375-0.688-0.688-1-1-0.063-0.063-0.125-0.125-0.188-0.25 1.625-3.563 4.188-6.188 7.875-7.75-0.063-0.063-0.063-0.063-0.063-0.063s0 0 0 0c-0.938-0.938-1.875-1.813-2.75-2.75-0.375-0.313-0.688-0.438-1.125-0.188-0.563 0.25-1.063 0.563-1.563 0.875-1.75 1.188-3.188 2.625-4.375 4.313-0.375 0.563-0.75 1.125-1.063 1.813-0.188 0.375-0.188 0.625 0.188 0.938 0.938 0.938 1.875 1.875 2.813 2.813-0.813 1.813-1.188 3.875-1.188 5.938 0 8.313 6.75 15.063 15 15.063 8.313 0 15.063-6.75 15.063-15.063 0-8.25-6.75-15-15.063-15zM18.5 24.313c1.25-2.875 3.25-4.813 6-6.125 0.5 2.563 1 5 1.5 7.688-2.625-0.563-5-1.063-7.5-1.563z"/></svg>',
        'meetedgar' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M14.9,4.4c5.2,0,9.4,4.1,9.4,9.1c0,3.1-1.5,5.7-3.8,7.4c0.7,0.4,1.6,0.6,2.6,0.6c2.3,0,4.3-1.5,5.1-3.5c0.1,0.6,0.2,1.1,0.2,1.7c0,3.1-2.6,5.7-5.9,5.7c-1.7,0-3.1-0.6-4.3-1.8c0.3,0.6,0.6,1,1.1,1.4c1,0.9,2.3,1.3,3.6,1.3c0.9,0,1.9-0.2,2.7-0.6c-0.3,0.5-0.6,1-1,1.4c-1.1,1.2-2.7,1.9-4.3,1.9c-1.4,0-2.8-0.5-3.9-1.6c-0.7-0.6-1.3-1.4-1.6-2.3c-0.3,0.9-0.9,1.6-1.6,2.3c-1.1,0.9-2.6,1.5-3.9,1.5c-1.6,0-3.2-0.6-4.3-1.8c-0.4-0.5-0.7-0.9-0.9-1.4c0.6,0.5,1.5,0.7,2.4,0.7c1.3,0,2.6-0.4,3.6-1.3c0.3-0.3,0.6-0.7,0.9-1c-1.1,0.8-2.3,1.3-3.7,1.3c-3.3,0-5.9-2.6-5.9-5.7c0-0.6,0.1-1.2,0.3-1.7c0.8,2.1,2.8,3.5,5.1,3.5c0.9,0,1.8-0.3,2.5-0.6c-2.3-1.7-3.8-4.3-3.8-7.3C5.4,8.5,9.6,4.4,14.9,4.4 M14.9,3.1C8.9,3.1,4.1,7.8,4.1,13.5c0,2.4,0.9,4.8,2.4,6.6c-1.6-0.1-3.1-1.1-3.6-2.6c-0.1-0.6-0.7-0.9-1.3-0.9s-1.1,0.4-1.3,0.9C0.1,18.3,0,18.9,0,19.7c0,2.3,1.1,4.1,2.6,5.4c-0.1,0.4-0.3,0.8,0,1.2c0.3,0.6,0.8,1.3,1.2,1.8c1.4,1.4,3.4,2.3,5.4,2.3c1.8,0,3.6-0.6,4.8-1.8c0.3-0.3,0.5-0.4,0.6-0.6c0.3,0.3,0.5,0.4,0.8,0.7c1.4,1.2,3,1.9,4.8,1.9c2,0,4-0.8,5.3-2.3c0.5-0.6,0.9-1.1,1.3-1.8c0.1-0.3,0.1-0.7,0-1c1.8-1.3,2.9-3.4,2.9-5.6c0-0.7-0.1-1.4-0.4-2.1c-0.1-0.6-0.7-0.9-1.3-1c-0.6,0-1.1,0.4-1.3,0.9c-0.5,1.6-1.9,2.6-3.6,2.7c1.5-1.9,2.4-4.2,2.4-6.7C25.7,7.8,20.8,3.1,14.9,3.1z M19.1,11.5c-1.7,0-3.1,1.4-3.3,3.1h-2.1c-0.1-1.7-1.5-3.1-3.3-3.1c-1.9,0-3.3,1.4-3.3,3.3c0,1.8,1.4,3.3,3.3,3.3c1.7,0,3-1.3,3.3-2.9h2.1c0.2,1.7,1.6,2.9,3.3,2.9c1.8,0,3.3-1.4,3.3-3.3C22.4,12.9,20.9,11.5,19.1,11.5z M10.6,17.6c-1.5,0-2.8-1.3-2.8-2.8c0-1.6,1.3-2.8,2.8-2.8s2.8,1.3,2.8,2.8C13.4,16.3,12.1,17.6,10.6,17.6z M19.1,17.6c-1.5,0-2.8-1.3-2.8-2.8c0-1.6,1.3-2.8,2.8-2.8s2.8,1.3,2.8,2.8C21.9,16.3,20.6,17.6,19.1,17.6z M19.1,18.3c-1.7,0-3.1-1.3-3.4-2.9h-1.8c-0.3,1.7-1.7,2.9-3.4,2.9c-1.8,0-3.4-1.5-3.4-3.4c0-1.8,1.6-3.4,3.4-3.4c1.8,0,3.2,1.3,3.4,3.1h1.8c0.2-1.7,1.7-3.1,3.4-3.1c1.8,0,3.4,1.6,3.4,3.4C22.5,16.8,21.1,18.3,19.1,18.3z M13.7,15.1H16v0.1c0.2,1.6,1.5,2.8,3.1,2.8c1.8,0,3.1-1.4,3.1-3.1s-1.4-3.1-3.1-3.1c-1.6,0-3.1,1.3-3.1,2.9v0.1h-2.3v-0.1c-0.2-1.6-1.5-2.9-3.1-2.9c-1.8,0-3.1,1.4-3.1,3.1s1.4,3.1,3.1,3.1C12.2,17.9,13.5,16.8,13.7,15.1L13.7,15.1z M19.1,17.8c-1.6,0-2.9-1.3-2.9-2.9s1.3-2.9,2.9-2.9s2.9,1.3,2.9,2.9S20.8,17.8,19.1,17.8z M19.1,12.2c-1.4,0-2.6,1.2-2.6,2.6s1.2,2.6,2.6,2.6s2.6-1.2,2.6-2.6S20.6,12.2,19.1,12.2z M10.6,17.8c-1.6,0-2.9-1.3-2.9-2.9S8.9,12,10.6,12s2.9,1.3,2.9,2.9S12.2,17.8,10.6,17.8z M10.6,12.2c-1.4,0-2.6,1.2-2.6,2.6s1.2,2.6,2.6,2.6s2.6-1.2,2.6-2.6S12,12.2,10.6,12.2z M28.4,5.9c0,0.4-0.3,0.7-0.7,0.7s-0.8-0.3-0.8-0.7c0-0.4,0.4-0.8,0.8-0.8S28.4,5.5,28.4,5.9z M30.3,1.5c-1,0-1.8,0.8-1.8,1.8c0,1,0.8,1.8,1.8,1.8c0.9,0,1.8-0.8,1.8-1.8C32,2.3,31.2,1.5,30.3,1.5z M30.3,4.3c-0.5,0-0.9-0.4-0.9-0.9c0-0.5,0.4-0.9,0.9-0.9s0.9,0.4,0.9,0.9C31.1,3.8,30.8,4.3,30.3,4.3z"/></svg>',
        'fintel' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.9,0c8.8,0,15.9,7.1,15.9,16c0,8.8-7.1,16-15.9,16c-1.9,0-3.8-0.4-5.5-1.1v0.1V19.3h6.8v-5.4h-6.8v-3.8H20V4.8H4.7v9.1H0.1C1.1,6,7.8,0,15.9,0z M8.7,30.2L8.7,30.2L8.7,30.2z M8.4,30.1c-0.1,0-0.1-0.1-0.2-0.1L8.4,30.1z M7.4,29.5c-0.1,0-0.1,0-0.1-0.1C7.3,29.5,7.3,29.5,7.4,29.5z M5.5,28.1L5.5,28.1L5.5,28.1z M5.3,27.8l-0.1-0.1L5.3,27.8z M5,27.6c-0.1,0-0.1-0.1-0.2-0.1C4.9,27.5,4.9,27.6,5,27.6z M4.7,27.3c-2.2-2.2-3.8-4.9-4.5-8.1h4.5V27.3z M9.5,30.6l0.4,0.2V18.8h6.8v-4.5H10V9.8h9.4V5.5h-0.3v3.8H9.4v5.3h6.9v3.7H9.5V30.6z"/></svg>',
        'mix' => '<svg width="28" height="32" viewBox="0 0 28 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M0 4v21.806c0 3.512 5.5 3.631 5.5 0v-14.912c0.494-3.306 5.5-3.15 5.5 0.406v10.956c0 3.619 6 3.625 6 0v-7.256c0.331-3.419 5.5-3.281 5.5 0.269v1.487c0 3.744 5.5 3.538 5.5 0v-12.756h-28z"/></svg>',
        'instapaper' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.1,31.1c-1.9-0.1-3.3-0.4-3.8-0.9s-0.9-1.6-0.9-3.5V5.3c0-1.8,0.3-2.9,0.9-3.4s1.9-0.8,3.8-0.9V0H8.9v0.9c2,0.1,3.3,0.4,3.8,0.9s0.9,1.6,0.9,3.4v21.5c0,1.9-0.3,3.1-0.9,3.5s-1.8,0.8-3.8,0.9V32h14.3V31.1z"/></svg>',
        'copy' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.313 28v-18.688h-14.625v18.688h14.625zM25.313 6.688c1.438 0 2.688 1.188 2.688 2.625v18.688c0 1.438-1.25 2.688-2.688 2.688h-14.625c-1.438 0-2.688-1.25-2.688-2.688v-18.688c0-1.438 1.25-2.625 2.688-2.625h14.625zM21.313 1.313v2.688h-16v18.688h-2.625v-18.688c0-1.438 1.188-2.688 2.625-2.688h16z"/></svg>',
        'link' => '<svg height="32" viewBox="0 0 32 32" width="32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M11.8,25.4c0.4-0.4,0.8-0.5,1.3-0.5s1,0.2,1.5,0.5c0.8,0.9,0.8,1.8,0,2.8l-1.7,1.6C11.4,31.2,9.6,32,7.6,32s-3.8-0.8-5.3-2.3S0,26.5,0,24.5c0-2.1,0.8-3.9,2.3-5.4l5.9-5.9c1.9-1.8,3.7-2.8,5.7-3c2-0.2,3.7,0.3,5.2,1.7c0.4,0.4,0.6,0.9,0.6,1.4c0,0.5-0.2,1-0.6,1.5c-0.9,0.9-1.9,0.9-2.8,0c-1.3-1.3-3.1-0.9-5.3,1.3l-5.9,5.9C4.4,22.6,4,23.5,4,24.5s0.4,1.8,1.1,2.4C5.8,27.6,6.6,28,7.6,28s1.8-0.4,2.5-1.1L11.8,25.4 M29.7,2.4C31.2,3.9,32,5.7,32,7.7s-0.8,3.8-2.3,5.3l-6.3,6.3c-2,2-4,2.9-6,2.9c-1.6,0-3.1-0.7-4.4-2c-0.4-0.4-0.5-0.8-0.5-1.3c0-0.5,0.2-1,0.5-1.5c0.4-0.3,0.9-0.5,1.4-0.5c0.5,0,1,0.2,1.4,0.5c1.3,1.3,3,1,4.8-0.9l6.3-6.2c0.8-0.7,1.2-1.6,1.2-2.5c0-1-0.4-1.9-1.2-2.5c-0.6-0.7-1.3-1.1-2.2-1.2S23,4.1,22.3,4.8l-2,2c-0.4,0.4-0.9,0.5-1.4,0.5s-1-0.2-1.4-0.5c-0.9-0.9-0.9-1.8,0-2.8l2-2c1.4-1.5,3.1-2.1,5.1-2S28.3,0.9,29.7,2.4"/></svg>',
        'itunes' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path class="st0" d="M16,3.5C9.2,3.5,3.8,8.9,3.8,15.7S9.2,27.9,16,27.9s12.2-5.5,12.2-12.2C28.2,8.9,22.7,3.4,16,3.5L16,3.5z M21.6,20.6c-0.2,1-1,1.5-1.9,1.7c-0.9,0.2-1.6,0.2-2.3-0.4c-0.8-0.7-0.9-1.9-0.1-2.6c0.6-0.6,1.4-0.7,2.7-0.9c0.2,0,0.4-0.1,0.5-0.3c0.2-0.3,0.2-0.1,0.2-5.8c0-0.4-0.2-0.5-0.6-0.4c-0.3,0.1-6.6,1.2-6.6,1.2c-0.4,0.1-0.5,0.2-0.5,0.6c0,8.3,0,7.9-0.1,8.5c-0.2,0.6-0.5,1.1-1.1,1.4c-0.6,0.3-1.7,0.5-2.2,0.4c-1.5-0.3-2.1-2.1-1-3.1c0.6-0.6,1.4-0.7,2.7-0.9c0.2,0,0.4-0.1,0.6-0.3c0.4-0.4,0.1-9.1,0.2-9.6c0-0.2,0.1-0.3,0.3-0.5c0.2-0.1,0.4-0.2,0.5-0.2C20.1,8.2,20.9,8,21.1,8c0.4,0,0.6,0.2,0.6,0.6C21.7,20.8,21.7,20.2,21.6,20.6L21.6,20.6z M24.7,0H7.3C3.3,0,0,3.3,0,7.3v17.3C0,28.7,3.3,32,7.3,32h17.3c4.1,0,7.3-3.3,7.3-7.3V7.3C32,3.3,28.7,0,24.7,0z M16,29.4c-7.6,0-13.8-6.2-13.8-13.8S8.4,1.9,16,1.9s13.8,6.2,13.8,13.8S23.6,29.4,16,29.4z"/></svg>',
        'deviantart' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.188 17.125c-1.5-1.813-3.375-2.938-5.5-3.813-2.75-1.125-5.625-1.563-8.563-1.625-0.188 0-0.438 0-0.75 0 0-1 0-1.938 0-3-1.313 0.125-2.563 0.313-4.188 0.438 0 0.188 0 0.25 0 0.375 0 0.75 0 1.563 0 2.313 0.063 0.25-0.063 0.375-0.313 0.438-2.125 0.438-4.125 1.125-6 2.25-1.438 0.875-2.688 1.938-3.625 3.375-1.125 1.688-1.563 3.563-1.063 5.5 5.125 0 10.063 0 15.188 0 0-3.188 0-6.125 0-9.188 0.625 0 1.313 0 1.938 0 1.625 0.125 3.25 0.375 4.75 1 2 0.938 3.375 2.375 3.938 4.5 0.063 0.125 0.063 0.5 0.125 0.5-1.813 0-3.375 0-5.313 0 0 0 0-0.313 0-0.438 0-1.188 0-2.438 0-3.688 0-0.25-0.063-0.375-0.313-0.375-0.813-0.188-1.5-0.313-2.313-0.438-0.5-0.063-1.25-0.063-1.563-0.125 0 2.813 0 5.688 0 8.25 5.125 0 10.063 0 15.188 0 0.063-0.625 0.188-0.938 0.188-1.375 0.063-1.875-0.625-3.438-1.813-4.875zM11.188 20.188c-1.938 0-3.5 0-5.25 0 0.125-2.25 2.688-5.063 5.25-5.375 0 1.75 0 3.438 0 5.375z"></path></svg>',
        'paypal' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 27 32" width="27" height="32"><path class="st0" d="M7.8,18.8c-0.2,1.4-1.2,7.6-1.5,9.4c0,0.1-0.1,0.2-0.2,0.2H0.9c-0.5,0-0.9-0.5-0.9-1L4.1,1.3c0.1-0.7,0.7-1.2,1.4-1.2c10.7,0,11.6-0.3,14.3,0.8c4.2,1.6,4.6,5.6,3.1,9.9c-1.5,4.4-5.1,6.3-9.9,6.4C10.1,17.1,8.2,16.6,7.8,18.8L7.8,18.8z M25.1,8.7c-0.1-0.1-0.2-0.1-0.2,0.1c-0.1,0.8-0.4,1.6-0.6,2.4c-2.8,8-10.6,7.3-14.4,7.3c-0.4,0-0.7,0.2-0.8,0.7C7.5,29,7.2,31,7.2,31c-0.1,0.5,0.2,0.9,0.7,0.9h4.5c0.6,0,1.1-0.4,1.2-1c0-0.4-0.1,0.4,1-6.4c0.3-1.5,1-1.4,2.1-1.4c5,0,8.9-2,10-7.9C27.2,12.7,27.1,10.2,25.1,8.7L25.1,8.7z"/></svg>',
        'tripadvisor' => '<svg version="1.1" width="50" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 50 32" ><path d="M45.8,9.3l4.1-4.4h-9c-9.6-6.5-22.2-6.5-31.8,0H0.1l4.1,4.4C-0.9,14-1.2,21.9,3.4,26.9C8.1,32,16,32.3,21,27.7l4,4.3l4-4.3c5,4.7,12.9,4.4,17.6-0.7c2.1-2.3,3.3-5.3,3.3-8.5h0C49.9,15,48.4,11.7,45.8,9.3z M12.5,27c-4.7,0-8.4-3.8-8.4-8.4s3.8-8.4,8.4-8.4s8.4,3.8,8.4,8.4S17.2,27,12.5,27L12.5,27z M25,18.3c0-5.5-4-10.3-9.4-12.3c6-2.5,12.7-2.5,18.7,0C29,8,25,12.7,25,18.3z M37.4,27L37.4,27c-4.7,0-8.4-3.8-8.4-8.4s3.8-8.4,8.4-8.4c4.7,0,8.4,3.8,8.4,8.4C45.9,23.2,42.1,27,37.4,27z M12.5,14.1L12.5,14.1c-2.4,0-4.4,2-4.4,4.4c0,2.4,2,4.4,4.4,4.4s4.4-2,4.4-4.4l0,0v0C17,16.1,15,14.1,12.5,14.1C12.5,14.1,12.5,14.1,12.5,14.1z M37.4,14.1c-2.4,0-4.4,2-4.4,4.4c0,2.4,2,4.4,4.4,4.4c2.4,0,4.4-2,4.4-4.4l0,0C41.9,16.1,39.9,14.1,37.4,14.1z"/></svg>',
        'snapchat' => '<svg width="30" height="32" viewBox="0 0 30 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.143 2.571c3.214-0.036 5.875 1.768 7.214 4.661 0.411 0.875 0.482 2.232 0.482 3.196 0 1.143-0.089 2.268-0.161 3.411 0.143 0.071 0.339 0.125 0.5 0.125 0.643 0 1.179-0.482 1.821-0.482 0.607 0 1.482 0.429 1.482 1.143 0 1.714-3.589 1.393-3.589 2.893 0 0.268 0.107 0.518 0.214 0.768 0.857 1.875 2.482 3.679 4.411 4.482 0.464 0.196 0.929 0.304 1.429 0.411 0.321 0.071 0.5 0.304 0.5 0.625 0 1.214-3.089 1.714-3.911 1.839-0.357 0.554-0.089 1.857-1.036 1.857-0.732 0-1.464-0.232-2.25-0.232-0.375 0-0.75 0.018-1.107 0.089-2.125 0.357-2.839 2.643-6.321 2.643-3.357 0-4.161-2.286-6.232-2.643-0.375-0.071-0.75-0.089-1.125-0.089-0.804 0-1.571 0.268-2.214 0.268-1 0-0.696-1.321-1.071-1.893-0.821-0.125-3.911-0.625-3.911-1.839 0-0.321 0.179-0.554 0.5-0.625 0.5-0.107 0.964-0.214 1.429-0.411 1.911-0.786 3.571-2.607 4.411-4.482 0.107-0.25 0.214-0.5 0.214-0.768 0-1.5-3.607-1.214-3.607-2.875 0-0.696 0.821-1.143 1.446-1.143 0.554 0 1.107 0.464 1.804 0.464 0.196 0 0.393-0.036 0.571-0.125-0.071-1.125-0.161-2.25-0.161-3.393 0-0.964 0.071-2.339 0.482-3.214 1.571-3.393 4.232-4.625 7.786-4.661z"></path></svg>',
        'medium' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M31.75 7.313l-10.125-5.063c-0.063 0-0.063 0-0.125 0-0.125 0-0.313 0.063-0.375 0.125l-6.188 10.188 6.938 11.313 10-16.188c0.063-0.125 0-0.313-0.125-0.375zM11.625 9v10.938l9.75 4.875zM22.188 25.188l8.938 4.5c0.438 0.25 0.875 0 0.875-0.563v-19.875zM10.5 7.375l-9.313-4.625-0.625-0.375c-0.063 0-0.125-0.063-0.188-0.063-0.125 0-0.188 0.063-0.25 0.125s-0.125 0.188-0.125 0.375v21.313c0 0.375 0.25 0.813 0.563 0.938l9.188 4.625c0.125 0.063 0.25 0.125 0.375 0.125 0.313 0 0.5-0.25 0.5-0.688v-21.563c0-0.063 0-0.125-0.125-0.188z"></path></svg>',
        'tiktok' => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path d="M16.707 0.027c1.747-0.027 3.48-0.013 5.213-0.027 0.107 2.040 0.84 4.12 2.333 5.56 1.493 1.48 3.6 2.16 5.653 2.387v5.373c-1.92-0.067-3.853-0.467-5.6-1.293-0.76-0.347-1.467-0.787-2.16-1.24-0.013 3.893 0.013 7.787-0.027 11.667-0.107 1.867-0.72 3.72-1.8 5.253-1.747 2.56-4.773 4.227-7.88 4.28-1.907 0.107-3.813-0.413-5.44-1.373-2.693-1.587-4.587-4.493-4.867-7.613-0.027-0.667-0.040-1.333-0.013-1.987 0.24-2.533 1.493-4.96 3.44-6.613 2.213-1.92 5.307-2.84 8.2-2.293 0.027 1.973-0.053 3.947-0.053 5.92-1.32-0.427-2.867-0.307-4.027 0.493-0.84 0.547-1.48 1.387-1.813 2.333-0.28 0.68-0.2 1.427-0.187 2.147 0.32 2.187 2.427 4.027 4.667 3.827 1.493-0.013 2.92-0.88 3.693-2.147 0.253-0.44 0.533-0.893 0.547-1.413 0.133-2.387 0.080-4.76 0.093-7.147 0.013-5.373-0.013-10.733 0.027-16.093z"></path></svg>',
        'patreon' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M32 12.175c0 6.331-5.15 11.488-11.488 11.488-6.356 0-11.525-5.15-11.525-11.488 0-6.35 5.169-11.519 11.525-11.519 6.338 0 11.488 5.169 11.488 11.519zM0 31.344h5.625v-30.688h-5.625v30.688z"></path></svg>',
        'mixer' => '<svg version="1.1" width="36" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 36 32"><path d="M6.6,1.5c-1.2-1.6-3.5-2-5.1-0.8C1.4,0.9,1.3,0.9,1.2,1c-1.4,1.3-1.5,3.5-0.4,5L8.2,16l-7.4,10c-1.1,1.5-1.1,3.7,0.4,5c1.5,1.4,3.8,1.3,5.2-0.2c0.1-0.1,0.2-0.2,0.2-0.3l10.4-13.9c0.2-0.3,0.2-0.8,0-1.1L6.6,1.5z M35.2,25.9l-7.4-10l7.4-9.9c1.1-1.5,1-3.7-0.4-5c-1.5-1.4-3.8-1.3-5.2,0.2c-0.1,0.1-0.2,0.2-0.2,0.3L19.1,15.4c-0.2,0.3-0.2,0.8,0,1.1l10.3,13.9c1.2,1.6,3.5,2,5.1,0.8c0.1-0.1,0.2-0.2,0.3-0.2C36.3,29.7,36.4,27.5,35.2,25.9z"/></svg>',
        'vimeo' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.688 9.125c-0.75 0-1.563 0.188-2.375 0.563 1.563-5.188 4.563-7.688 9-7.5 3.313 0.063 4.875 2.188 4.688 6.375-0.188 3.125-2.313 7.375-6.563 12.813-4.313 5.625-8 8.5-11 8.5-1.875 0-3.438-1.75-4.75-5.188-0.875-3.188-1.75-6.313-2.563-9.5-1-3.438-2-5.125-3.125-5.125-0.25 0-1.063 0.5-2.5 1.5l-1.5-1.938c1.563-1.438 3.125-2.813 4.688-4.188 2.063-1.813 3.688-2.75 4.75-2.875 2.438-0.25 4 1.438 4.563 5.125 0.625 3.938 1.063 6.375 1.313 7.313 0.688 3.25 1.5 4.875 2.375 4.875 0.688 0 1.688-1.063 3-3.125 1.313-2.125 2.063-3.75 2.188-4.875 0.188-1.813-0.563-2.75-2.188-2.75z"></path></svg>',
        'github' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M30.25 11.125c0-2.25-0.75-4.125-2.125-5.563 0.25-0.5 0.938-2.625-0.188-5.5 0 0-1.75-0.563-5.688 2.125-1.688-0.438-3.438-0.688-5.25-0.688-1.75 0-3.5 0.25-5.188 0.688-4-2.688-5.688-2.125-5.688-2.125-1.188 2.875-0.438 5-0.25 5.5-1.313 1.438-2.125 3.313-2.125 5.563 0 8 4.875 9.75 9.5 10.313-0.625 0.5-1.188 1.438-1.375 2.75-1.188 0.563-4.188 1.438-6-1.75 0 0-1.125-1.938-3.188-2.125 0 0-2.063 0-0.188 1.25 0 0 1.375 0.688 2.313 3.063 0 0 1.25 3.688 7 2.438 0.063 1.75 0.063 4.438 0.063 4.938h10.313c0-0.688 0-4 0-6.75 0-1.938-0.625-3.188-1.375-3.875 4.625-0.5 9.438-2.25 9.438-10.25zM4.125 21.313c-0.063 0.063-0.25 0.125-0.375 0.063s-0.25-0.25-0.188-0.313c0.063-0.125 0.188-0.188 0.375-0.063 0.125 0.063 0.188 0.188 0.188 0.313zM4.938 22.25c-0.063 0.063-0.313 0-0.438-0.125s-0.125-0.313-0.063-0.438c0.125-0.063 0.313-0.063 0.438 0.125 0.125 0.125 0.188 0.313 0.063 0.438zM5.75 23.438c-0.125 0.063-0.313 0-0.438-0.188s-0.125-0.438 0-0.5c0.125-0.063 0.313 0 0.438 0.188s0.125 0.375 0 0.5zM6.875 24.563c-0.125 0.125-0.375 0.125-0.5-0.063-0.188-0.188-0.25-0.375-0.125-0.5 0.125-0.188 0.375-0.125 0.5 0.063 0.188 0.125 0.25 0.375 0.125 0.5zM8.438 25.25c-0.063 0.188-0.313 0.25-0.5 0.188-0.25-0.063-0.438-0.25-0.375-0.438s0.313-0.25 0.563-0.188c0.188 0.063 0.375 0.25 0.313 0.438zM9.688 25.688c-0.25 0-0.438-0.125-0.438-0.313s0.188-0.313 0.438-0.313c0.25 0 0.438 0.125 0.438 0.313s-0.188 0.313-0.438 0.313zM11.313 25.5c-0.25 0.063-0.438-0.063-0.5-0.25 0-0.125 0.188-0.313 0.438-0.375s0.438 0.063 0.5 0.25c0 0.125-0.188 0.313-0.438 0.375z"></path></svg>',
        'instagram' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M16 2.875c4.313 0 4.75 0.063 6.438 0.125 1.625 0.063 2.438 0.313 3 0.5 0.75 0.313 1.313 0.688 1.813 1.188 0.563 0.563 0.938 1.125 1.188 1.813 0.25 0.625 0.5 1.438 0.563 3 0.063 1.75 0.125 2.188 0.125 6.5s-0.063 4.75-0.125 6.438c-0.063 1.625-0.313 2.438-0.5 3-0.313 0.75-0.688 1.313-1.188 1.813-0.563 0.563-1.125 0.938-1.813 1.188-0.625 0.25-1.438 0.5-3 0.563-1.75 0.063-2.188 0.125-6.5 0.125s-4.75-0.063-6.438-0.125c-1.625-0.063-2.438-0.313-3-0.5-0.75-0.313-1.313-0.688-1.813-1.188-0.563-0.563-0.938-1.125-1.188-1.813-0.25-0.625-0.5-1.438-0.563-3-0.063-1.75-0.125-2.188-0.125-6.5s0.063-4.75 0.125-6.438c0.063-1.625 0.313-2.438 0.5-3 0.313-0.75 0.688-1.313 1.188-1.813 0.563-0.563 1.125-0.938 1.813-1.188 0.625-0.25 1.438-0.5 3-0.563 1.75-0.063 2.188-0.125 6.5-0.125M16 0c-4.375 0-4.875 0.063-6.563 0.125-1.75 0.063-2.938 0.313-3.875 0.688-1.063 0.438-2 1-2.875 1.875s-1.438 1.813-1.875 2.875c-0.375 1-0.625 2.125-0.688 3.875-0.063 1.688-0.125 2.188-0.125 6.563s0.063 4.875 0.125 6.563c0.063 1.75 0.313 2.938 0.688 3.875 0.438 1.063 1 2 1.875 2.875s1.813 1.438 2.875 1.875c1 0.375 2.125 0.625 3.875 0.688 1.688 0.063 2.188 0.125 6.563 0.125s4.875-0.063 6.563-0.125c1.75-0.063 2.938-0.313 3.875-0.688 1.063-0.438 2-1 2.875-1.875s1.438-1.813 1.875-2.875c0.375-1 0.625-2.125 0.688-3.875 0.063-1.688 0.125-2.188 0.125-6.563s-0.063-4.875-0.125-6.563c-0.063-1.75-0.313-2.938-0.688-3.875-0.438-1.063-1-2-1.875-2.875s-1.813-1.438-2.875-1.875c-1-0.375-2.125-0.625-3.875-0.688-1.688-0.063-2.188-0.125-6.563-0.125zM16 7.75c-4.563 0-8.25 3.688-8.25 8.25s3.688 8.25 8.25 8.25c4.563 0 8.25-3.688 8.25-8.25s-3.688-8.25-8.25-8.25zM16 21.375c-2.938 0-5.375-2.438-5.375-5.375s2.438-5.375 5.375-5.375c2.938 0 5.375 2.438 5.375 5.375s-2.438 5.375-5.375 5.375zM26.438 7.438c0 1.063-0.813 1.938-1.875 1.938s-1.938-0.875-1.938-1.938c0-1.063 0.875-1.875 1.938-1.875s1.875 0.813 1.875 1.875z"></path></svg>',
        'soundcloud' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M0.625 21.125h-0.625v-3.875h0.625zM2.25 22.375h-0.625v-6.063h0.625zM3.5 22.75h-0.625v-7.063h0.625zM4.813 23.063h-0.625v-7.063h0.625zM6.375 23.063h-0.625v-9.313h0.625zM7.688 23.063h-0.625v-10.563h0.625zM9.25 23.063h-0.625v-11.25h0.625zM10.563 23.063h-0.625v-11.563h0.625zM12.188 23.063h-0.688v-11.25h0.688zM13.438 23.063h-0.625v-10.875h0.625zM14.75 23.063h-0.688v-12.188h0.688zM16.313 23.063h-0.625v-13.125h0.625zM28.063 22.938c-0.063 0-10.938 0-10.938 0-0.25 0-0.5-0.188-0.5-0.438v-12.5c0-0.25 0.125-0.375 0.438-0.5 0.75-0.313 1.625-0.438 2.5-0.438 3.625 0 6.625 2.75 6.938 6.313 0.5-0.188 1-0.313 1.563-0.313 2.188 0 3.938 1.75 3.938 3.938s-1.75 3.938-3.938 3.938z"></path></svg>',
        'behance' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M28.813 9.25h-8v-1.875h8zM15.563 16.813c0.625 0.875 0.938 1.875 0.938 3.125 0 1-0.188 1.875-0.563 2.563-0.438 0.75-0.938 1.313-1.563 1.813-0.688 0.438-1.438 0.75-2.25 1-0.813 0.188-1.688 0.313-2.563 0.313h-9.563v-19.875h9.25c0.938 0 1.813 0.188 2.625 0.375 0.75 0.188 1.375 0.5 1.938 0.875s1 0.938 1.313 1.563c0.313 0.563 0.438 1.375 0.438 2.313s-0.188 1.813-0.688 2.438c-0.438 0.688-1.125 1.25-2 1.625 1.25 0.375 2.125 1 2.688 1.875zM4.188 13.75h4.5c0.813 0 1.438-0.063 1.938-0.438s0.75-0.875 0.75-1.75c0-0.438-0.063-0.813-0.25-1.125-0.188-0.25-0.375-0.5-0.688-0.688-0.25-0.125-0.563-0.313-0.938-0.375s-0.75-0.125-1.125-0.125h-4.188zM12.188 19.688c0-1-0.313-1.688-0.875-2.125s-1.313-0.625-2.25-0.625h-4.875v5.438h4.75c0.438 0 0.875-0.063 1.25-0.125 0.375-0.125 0.688-0.25 1-0.438s0.563-0.438 0.688-0.813c0.188-0.313 0.313-0.75 0.313-1.313zM32 19.5h-10.313c0 1 0.375 2.188 1 2.75 0.563 0.563 1.438 0.875 2.5 0.875 0.813 0 1.5-0.25 2.063-0.688 0.563-0.375 0.875-0.688 1.063-1.313h3.438c-0.563 1.938-1.438 3-2.563 3.75s-2.5 1.188-4.125 1.188c-1.125 0-2.125-0.188-3.063-0.563-0.875-0.375-1.625-0.875-2.25-1.5-0.625-0.688-1.125-1.5-1.5-2.438-0.313-0.875-0.5-1.875-0.5-3 0-1.063 0.188-2.063 0.563-3 0.313-0.938 0.813-1.688 1.438-2.375 0.688-0.688 1.438-1.188 2.313-1.625 0.938-0.375 1.938-0.563 3-0.563 1.188 0 2.25 0.25 3.188 0.688 0.875 0.5 1.625 1.125 2.188 1.875 0.625 0.813 1 1.75 1.25 2.75s0.375 2.25 0.313 3.188zM28.063 16.938c-0.125-0.938-0.438-1.688-0.875-2.188-0.5-0.563-1.313-0.813-2.25-0.813-0.625 0-1.125 0.125-1.563 0.375-0.375 0.188-0.75 0.438-1 0.75s-0.375 0.625-0.5 1c-0.125 0.313-0.188 0.563-0.188 0.875z"></path></svg>',
        'foursquare' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M24.625 0c0 0-14.688 0-17.063 0-2.313 0-3 1.75-3 2.875s0 27.125 0 27.125c0 1.25 0.625 1.75 1 1.875 0.438 0.188 1.438 0.313 2.063-0.438 0 0 8.063-9.375 8.188-9.5 0.25-0.188 0.25-0.188 0.438-0.188 0.438 0 3.563 0 5.25 0 2.188 0 2.5-1.563 2.75-2.5 0.188-0.75 2.313-11.688 3.063-15.188 0.5-2.625-0.125-4.063-2.688-4.063zM24.25 19.25c0.188-0.75 2.313-11.688 3.063-15.188zM23.625 4.625l-0.688 3.75c-0.125 0.375-0.625 0.813-1.063 0.813-0.5 0-6.688 0-6.688 0-0.75 0-1.25 0.5-1.25 1.25v0.813c0 0.75 0.5 1.25 1.25 1.25 0 0 5.125 0 5.688 0 0.5 0 1 0.625 0.938 1.188-0.125 0.563-0.688 3.375-0.75 3.688-0.063 0.25-0.375 0.813-1.063 0.813-0.5 0-4.563 0-4.563 0-0.875 0-1.125 0.125-1.688 0.813s-5.563 6.75-5.563 6.75c-0.063 0.063-0.125 0.063-0.125 0v-21.188c0-0.5 0.438-1.063 1.063-1.063 0 0 13.125 0 13.688 0 0.5 0 0.938 0.5 0.813 1.125z"></path></svg>',
        'dribbble' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.938 0.125c-8.813 0-16 7.188-16 16s7.188 16 16 16c8.875 0 16-7.188 16-16s-7.125-16-16-16zM26.563 7.5c1.875 2.313 3.063 5.25 3.063 8.5-0.438-0.125-4.938-1-9.5-0.438-0.125-0.25-0.188-0.5-0.313-0.688-0.25-0.688-0.563-1.375-0.875-2 5-2.063 7.313-5 7.625-5.375zM15.938 2.438c3.5 0 6.688 1.313 9.063 3.438-0.188 0.375-2.25 3.125-7.125 4.938-2.25-4.063-4.75-7.438-5.125-8 1.063-0.25 2.125-0.375 3.188-0.375zM10.188 3.75c0.313 0.5 2.75 3.875 5.063 7.938-6.438 1.688-12.063 1.625-12.688 1.625 0.938-4.25 3.75-7.75 7.625-9.563zM2.313 16.125c0-0.125 0-0.25 0-0.438 0.563 0.063 7.188 0.125 14.063-1.938 0.375 0.75 0.75 1.563 1.063 2.313-0.188 0.063-0.313 0.125-0.5 0.188-7.063 2.25-10.813 8.5-11.125 9-2.188-2.438-3.5-5.625-3.5-9.125zM15.938 29.813c-3.125 0-6.063-1.125-8.375-2.875 0.25-0.563 3-5.875 10.75-8.563 0 0 0.063 0 0.063-0.063 1.938 5 2.75 9.188 2.938 10.375-1.625 0.688-3.438 1.125-5.375 1.125zM23.625 27.438c-0.188-0.813-0.875-4.813-2.688-9.75 4.313-0.688 8.063 0.438 8.5 0.625-0.563 3.813-2.75 7.063-5.813 9.125z"></path></svg>',
        'envato' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" width="28" height="32"><path d="M3.3,8.9c-7.3,10.2-0.7,18.5,3.6,21.2C12,33.2,22,33.2,26,24.4c5-11-0.9-23.5-2.3-24.2l0,0c-1.1-0.6-6.9,0.1-11.1,4.1C6,10.9,6.2,19.5,6.2,19.5S6,20.4,5,19.1c-2-2.6-1-8.5-0.8-9.4C4.3,8.6,3.6,8.5,3.3,8.9L3.3,8.9z"/></svg>',
        'rss' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.563 27.688c0 2.375-1.875 4.25-4.25 4.25s-4.25-1.875-4.25-4.25c0-2.313 1.875-4.25 4.25-4.25s4.25 1.938 4.25 4.25zM0.063 17c4 0 7.75 1.563 10.563 4.375s4.375 6.625 4.375 10.625h6.125c0-11.625-9.438-21.125-21.063-21.125zM0.063 6.125c14.188 0 25.75 11.625 25.75 25.875h6.125c0-17.625-14.313-32-31.875-32z"></path></svg>',
        'vine' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" width="28" height="32"><path class="st0" d="M28,15.9v3.8c-1.3,0.3-2.7,0.4-3.8,0.4c-2.7,5.6-7.5,10.5-9.1,11.4c-1,0.6-2,0.6-3.1-0.1c-2-1.2-9.5-7.3-12-26.7h5.4c1.4,11.6,4.7,17.6,8.4,22c2-2,4-4.7,5.5-7.8c-3.6-1.8-5.8-5.9-5.8-10.6c0-4.8,2.7-8.4,7.5-8.4c8.4,0,7.7,9.3,5.9,13.2c0,0-3.4,0.7-4.6-1.5c0.2-0.8,0.6-2.2,0.6-3.5c0-2.3-0.8-3.4-2.1-3.4c-1.3,0-2.2,1.2-2.2,3.6C18.5,14.2,22.9,17.1,28,15.9L28,15.9z"/></svg>',
        'slideshare' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" width="32" height="32"><path class="st0" d="M11.7,9.6c-2.1,0-3.9,1.6-3.9,3.6c0,2,1.7,3.6,3.9,3.6s3.9-1.6,3.9-3.6C15.6,11.2,13.9,9.6,11.7,9.6L11.7,9.6z M20.7,9.6c-2.1,0-3.9,1.6-3.9,3.6c0,2,1.7,3.6,3.9,3.6c2.1,0,3.9-1.6,3.9-3.6C24.6,11.2,22.8,9.6,20.7,9.6L20.7,9.6z M30.5,15.2l-0.4,0.3V3.1c0-1.7-1.3-3.1-2.9-3.1H4.8C3.2,0,1.9,1.4,1.9,3.1v12.4c-0.1-0.1-0.3-0.2-0.4-0.3c-0.9-0.7-1.6,0.2-1,1.1c1.1,1.4,3.3,3.1,6.6,4.5c-3.5,12,8.6,13.9,8.4,7.8c0,0,0-3.5,0-6c0.3,0.1,0.6,0.1,0.9,0.2c0,2.5,0,5.8,0,5.8c-0.2,6.1,11.9,4.2,8.4-7.7c3.3-1.4,5.5-3.1,6.6-4.5C32.1,15.5,31.4,14.6,30.5,15.2z M28.6,16.4c-4.3,2.3-8,1.9-10,1.9c-1.5-0.1-2,0.6-2.1,1.6c-0.6-0.5-1.2-1-1.3-1.1c-0.3-0.3-0.9-0.5-1.7-0.5c-2,0.1-5.6,0.5-9.8-1.7v-12c0-2.2,0.6-2.9,2.5-2.9H26c1.9,0,2.6,0.8,2.6,2.9L28.6,16.4L28.6,16.4z"/></svg>',
        '500px' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.904 21.024c0 0.032 0.16 0.48 0.256 0.704 0.512 1.248 1.28 2.368 2.24 3.328s2.080 1.728 3.328 2.24c1.28 0.544 2.656 0.832 4.064 0.832s2.784-0.288 4.064-0.832c1.248-0.512 2.368-1.28 3.328-2.24s1.728-2.080 2.24-3.328c0.544-1.28 0.832-2.656 0.832-4.064s-0.288-2.784-0.832-4.064c-0.512-1.248-1.28-2.368-2.24-3.328s-2.080-1.728-3.328-2.24c-1.28-0.544-2.656-0.832-4.064-0.832-1.44 0-2.848 0.288-4.128 0.832-1.024 0.416-2.752 1.536-3.744 2.592v0-8.672h14.496c0.512 0 0.512-0.736 0.512-0.992s0-0.992-0.544-0.992l-15.616 0.032c-0.416 0-0.704 0.352-0.704 0.672v12.128c0 0.384 0.48 0.672 0.928 0.768 0.896 0.192 1.088-0.096 1.312-0.384l0.032-0.032c0.32-0.48 1.376-1.536 1.376-1.536 1.6-1.6 3.776-2.496 6.080-2.496s4.448 0.896 6.048 2.496c1.632 1.632 2.496 3.776 2.496 6.048s-0.896 4.416-2.496 6.048c-1.6 1.6-3.808 2.496-6.080 2.496-1.536 0-3.040-0.416-4.32-1.184v-7.392c0-0.992 0.416-2.048 1.152-2.848 0.832-0.928 1.952-1.44 3.168-1.44 1.184 0 2.304 0.448 3.136 1.28 0.832 0.8 1.28 1.888 1.28 3.040 0 2.464-1.952 4.384-4.416 4.384-0.48 0-1.344-0.224-1.376-0.224-0.512-0.16-0.704 0.544-0.768 0.768-0.256 0.864 0.128 1.056 0.224 1.088 0.8 0.256 1.312 0.288 2.016 0.288 3.488 0 6.336-2.848 6.336-6.336 0-3.456-2.848-6.304-6.336-6.304-1.696 0-3.328 0.64-4.512 1.856-1.152 1.12-1.824 2.624-1.824 4.128v0.032c0 0.192 0 4.608 0 6.048v0c-0.672-0.736-1.312-1.856-1.728-2.976-0.16-0.448-0.544-0.352-1.056-0.192-0.288 0.096-0.992 0.288-0.832 0.8v0zM15.36 19.296c0 0.224 0.192 0.384 0.32 0.512v0.032c0.192 0.192 0.384 0.288 0.576 0.288 0.16 0 0.224-0.064 0.256-0.096 0.096-0.096 1.088-1.088 1.184-1.184l1.12 1.088c0.096 0.128 0.224 0.16 0.352 0.192 0.192 0 0.384-0.096 0.576-0.32 0.48-0.48 0.224-0.736 0.128-0.864l-1.12-1.12 1.152-1.184c0.256-0.288 0.032-0.576-0.192-0.8-0.32-0.32-0.64-0.416-0.832-0.224l-1.152 1.152-1.184-1.184c-0.064-0.064-0.128-0.096-0.224-0.096-0.16 0-0.352 0.096-0.544 0.32-0.352 0.352-0.448 0.608-0.256 0.8l1.184 1.184-1.152 1.184c-0.16 0.096-0.192 0.224-0.192 0.32zM17.92 3.424c-1.888 0-3.872 0.384-5.344 1.024-0.16 0.064-0.256 0.192-0.256 0.352-0.032 0.16 0.032 0.384 0.128 0.672 0.096 0.224 0.32 0.864 0.8 0.672 1.504-0.576 3.168-0.896 4.672-0.896 1.728 0 3.36 0.32 4.928 0.992 1.248 0.512 2.4 1.28 3.68 2.4 0.096 0.096 0.192 0.128 0.288 0.128 0.256 0 0.48-0.256 0.704-0.48 0.352-0.384 0.576-0.704 0.224-1.024-1.216-1.152-2.56-2.016-4.192-2.72-1.792-0.736-3.68-1.12-5.632-1.12zM28 26.592v0c-0.224-0.224-0.416-0.352-0.576-0.416s-0.32 0-0.448 0.096l-0.096 0.128c-1.152 1.152-2.528 2.080-4.032 2.72-1.568 0.672-3.232 0.992-4.928 0.992s-3.36-0.32-4.928-0.992c-1.504-0.64-2.848-1.536-4.032-2.72-1.216-1.216-2.112-2.56-2.72-4.032-0.576-1.408-0.768-2.496-0.832-2.848 0-0.032 0-0.064 0-0.064-0.064-0.416-0.448-0.448-0.992-0.352-0.224 0.032-0.928 0.128-0.864 0.64v0c0.192 1.152 0.512 2.272 0.96 3.36 0.736 1.728 1.792 3.296 3.104 4.608 1.344 1.344 2.88 2.4 4.608 3.104 1.792 0.768 3.712 1.152 5.664 1.152s3.872-0.384 5.664-1.152c1.728-0.736 3.296-1.792 4.608-3.104 0 0 0.064-0.064 0.128-0.128 0.192-0.128 0.32-0.416-0.288-0.992z"></path></svg>',
        'flickr' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M7.25 23.25c-4 0-7.25-3.25-7.25-7.25s3.25-7.25 7.25-7.25c4 0 7.25 3.25 7.25 7.25s-3.25 7.25-7.25 7.25zM24.75 23.25c-4 0-7.25-3.25-7.25-7.25s3.25-7.25 7.25-7.25c4 0 7.25 3.25 7.25 7.25s-3.25 7.25-7.25 7.25z"></path></svg>',
        'wp_posts' => '<svg width="28" height="32" version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 28 32" ><path class="st0" d="M27.1,4.1l-3.2-3.2C23.3,0.3,22.6,0,21.8,0H11C9.3,0,8,1.3,8,3v3H3C1.3,6,0,7.3,0,9v20c0,1.7,1.3,3,3,3h14c1.7,0,3-1.3,3-3v-3h5c1.7,0,3-1.3,3-3V6.2C28,5.4,27.7,4.7,27.1,4.1z M16.6,29H3.4C3.2,29,3,28.8,3,28.6V9.4C3,9.2,3.2,9,3.4,9H8v14c0,1.7,1.3,3,3,3h6v2.6C17,28.8,16.8,29,16.6,29z M24.6,23H11.4c-0.2,0-0.4-0.2-0.4-0.4V3.4C11,3.2,11.2,3,11.4,3H18v5.5c0,0.8,0.7,1.5,1.5,1.5H25v12.6C25,22.8,24.8,23,24.6,23z M25,7h-4V3h0.6c0.1,0,0.2,0,0.3,0.1l3,3C25,6.2,25,6.3,25,6.4V7z"/></svg>',
        'wp_comments' => '<svg version="1.1" width="42" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 42 32" ><path d="M38.4,25.3c2-1.9,3.1-4.4,3.1-7C41.6,12.6,36.1,7.8,29,7c-2.3-4.1-7.5-7-13.7-7C7.1,0,0.4,5.1,0.4,11.4c0,2.6,1.2,5.1,3.1,7c-1.1,2.2-2.7,3.9-2.7,3.9c-0.5,0.5-0.6,1.2-0.3,1.8c0.3,0.6,0.9,1,1.5,1c3.8,0,6.9-1.4,8.9-2.8c0.7,0.2,1.3,0.3,2,0.4c2.2,4.1,7.5,7,13.7,7c1.5,0,2.9-0.2,4.3-0.5c2,1.3,5.1,2.8,8.9,2.8c0.7,0,1.3-0.4,1.5-1c0.3-0.6,0.1-1.3-0.3-1.8C41.1,29.2,39.5,27.5,38.4,25.3z M10.4,18.7l-1.2,0.8c-1,0.6-2,1.2-3.1,1.5c0.2-0.3,0.4-0.7,0.6-1.1l1.1-2.2L6,16c-1-1-2.1-2.5-2.1-4.6c0-4.3,5.2-8,11.4-8s11.4,3.7,11.4,8s-5.2,8-11.4,8c-1.2,0-2.4-0.1-3.5-0.4L10.4,18.7L10.4,18.7z M36,22.9l-1.8,1.7l1.1,2.2c0.2,0.4,0.4,0.7,0.6,1.1c-1-0.4-2.1-0.9-3.1-1.5l-1.2-0.8l-1.4,0.3c-1.1,0.3-2.3,0.4-3.5,0.4c-3.9,0-7.3-1.4-9.4-3.6c7.2-0.8,12.8-5.5,12.8-11.3c0-0.2,0-0.5-0.1-0.7c4.6,1,8,4.1,8,7.6C38.1,20.3,37,21.9,36,22.9z"/></svg>',
        'wp_users' => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 46 32" width="46" height="32"><path d="M13.9,16c4.4,0,8-3.6,8-8s-3.6-8-8-8s-8,3.6-8,8S9.4,16,13.9,16z M19.3,18.3h-0.6c-1.5,0.7-3.1,1.1-4.9,1.1S10.5,19,9,18.3H8.4c-4.5,0-8.2,3.7-8.2,8.2v2.1c0,1.9,1.5,3.4,3.4,3.4h20.6c1.9,0,3.4-1.5,3.4-3.4v-2.1C27.6,22,23.9,18.3,19.3,18.3z M34.4,16c3.8,0,6.9-3.1,6.9-6.9s-3.1-6.9-6.9-6.9c-3.8,0-6.9,3.1-6.9,6.9S30.6,16,34.4,16z M37.9,18.3h-0.3c-1,0.3-2,0.6-3.2,0.6c-1.1,0-2.2-0.2-3.2-0.6H31c-1.5,0-2.8,0.4-4,1.1c1.7,1.9,2.8,4.4,2.8,7.1v2.7c0,0.2,0,0.3,0,0.5h12.6c1.9,0,3.4-1.5,3.4-3.4C45.9,21.9,42.3,18.3,37.9,18.3z"/></svg>',
        'steamcommunity' => '<svg version="1.1" width="32" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 32 32" ><path class="st0" d="M32,16c0,8.8-7.2,16-16,16C8.6,32,2.5,27.1,0.6,20.4l6.1,2.5c0.4,2.1,2.3,3.6,4.4,3.6c2.5,0,4.6-2.1,4.5-4.7l5.5-3.9c3.4,0.1,6.2-2.6,6.2-6c0-3.3-2.7-6-6-6s-6,2.7-6,6V12l-3.8,5.5c-1-0.1-2,0.2-2.8,0.8L0,14.7C0.7,6.5,7.6,0,16,0C24.8,0,32,7.2,32,16z M10,24.3l-2-0.8c0.4,0.8,1,1.3,1.8,1.7c1.7,0.7,3.7-0.1,4.5-1.8c0.3-0.8,0.4-1.8,0-2.6s-1-1.5-1.8-1.8c-0.8-0.3-1.7-0.3-2.5,0l2,0.8c1.3,0.5,1.9,2,1.3,3.3C12.8,24.2,11.3,24.8,10,24.3z M21.3,15.9c-2.2,0-4-1.8-4-4s1.8-4,4-4s4,1.8,4,4S23.5,15.9,21.3,15.9z M21.3,14.9c1.7,0,3-1.4,3-3c0-1.7-1.4-3-3-3s-3,1.4-3,3C18.2,13.5,19.6,14.9,21.3,14.9z"/></svg>',
        'feedly' => '<svg version="1.1" width="37" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 37 32" ><path fill="none" d="M19.5,15.4c-0.1-0.1-0.3-0.2-0.6-0.2c-0.2,0-0.4,0.1-0.6,0.2l-7.1,7.1c-0.1,0.1-0.2,0.3-0.2,0.6c0,0.2,0.1,0.4,0.2,0.6l1,1c0.1,0.1,0.3,0.2,0.5,0.2h1.7c0.2,0,0.4-0.1,0.6-0.2l6.2-6.2c0.3-0.3,0.3-0.8,0-1.1L19.5,15.4z"/><path fill="none" d="M20.7,8.4l-1.9-1.9c-0.1-0.1-0.3-0.2-0.6-0.2c-0.2,0-0.4,0.1-0.6,0.2L6.5,17.8c-0.1,0.1-0.2,0.3-0.2,0.6c0,0.2,0.1,0.4,0.2,0.6l1,1c0.1,0,0.3,0.1,0.5,0.1h1.7c0.2,0,0.4-0.1,0.5-0.2L20.7,9.5C21,9.2,21,8.7,20.7,8.4z"/><path d="M35.8,15.6L21.4,1.2C20.6,0.4,19.6,0,18.5,0s-2.1,0.4-2.9,1.2L1.2,15.6c-1.6,1.6-1.6,4.1,0,5.7l9.5,9.5c0.8,0.8,1.8,1.2,2.9,1.2h9.9h0.1c1.1,0,2.1-0.4,2.9-1.2l9.4-9.5c0.8-0.8,1.2-1.8,1.2-2.9C37,17.4,36.5,16.4,35.8,15.6z M10.3,19.9c-0.1,0.1-0.3,0.2-0.5,0.2H8c-0.2,0-0.4-0.1-0.6-0.2l-1-1c-0.1-0.1-0.2-0.3-0.2-0.6c0-0.2,0.1-0.4,0.2-0.6L17.7,6.5c0.1-0.1,0.3-0.2,0.6-0.2c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9c0.3,0.3,0.3,0.8,0,1.1L10.3,19.9z M20.6,28.1L20.6,28.1c-0.1,0.1-0.1,0.1-0.1,0.1l-1,1c-0.1,0.1-0.3,0.2-0.5,0.2h-1.8c-0.2,0-0.4-0.1-0.5-0.2l-1-1c-0.1-0.2-0.2-0.4-0.2-0.6c0-0.3,0.1-0.5,0.2-0.6l1.8-1.9c0.1-0.1,0.3-0.1,0.4-0.2c0.1-0.1,0.3-0.1,0.5-0.1c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9C20.9,27.3,20.9,27.8,20.6,28.1z M21.4,18.4l-6.2,6.2c-0.1,0.1-0.3,0.2-0.6,0.2h-1.7c-0.2,0-0.4-0.1-0.5-0.2l-1-1c-0.1-0.1-0.2-0.3-0.2-0.6c0-0.2,0.1-0.4,0.2-0.6l7.1-7.1c0.1-0.1,0.3-0.2,0.6-0.2c0.2,0,0.4,0.1,0.6,0.2l1.9,1.9C21.7,17.6,21.7,18.1,21.4,18.4z"/></svg>',
        'spotify' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M25.813 25.938c-0.375 0.625-1.25 0.875-1.875 0.438-5.313-3.188-11.938-3.938-19.75-2.125-0.75 0.125-1.5-0.313-1.688-1.063s0.313-1.5 1.063-1.688c8.563-1.938 15.875-1.125 21.813 2.5 0.688 0.375 0.875 1.25 0.438 1.938zM28.563 19.813c-0.5 0.813-1.563 1.063-2.375 0.563-6.063-3.688-15.25-4.75-22.438-2.625-0.875 0.313-1.875-0.25-2.188-1.125-0.25-0.938 0.25-1.938 1.188-2.188 8.188-2.5 18.313-1.313 25.25 2.938 0.813 0.563 1.125 1.625 0.563 2.438zM31.688 12.688c-0.563 1-1.875 1.313-2.875 0.75-7.25-4.313-19.188-4.688-26.125-2.625-1.063 0.375-2.25-0.25-2.625-1.375-0.313-1.125 0.313-2.313 1.438-2.625 7.938-2.438 21.125-1.938 29.5 3 1 0.625 1.313 1.875 0.688 2.875z"></path></svg>',
        'twitch' => '<svg width="32" height="32" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22.938 27.813h-6.25l-4.188 4.188h-4.125v-4.188h-7.688v-22.25l2.125-5.563h28.5v19.5zM28.5 18.063v-15.313h-22.938v20.188h6.25v4.188l4.188-4.188h7.625zM20.875 8.375v8.313h2.75v-8.313zM13.188 16.688h2.813v-8.313h-2.813z"></path></svg>',
        'periscope' => '<svg version="1.1" width="26" height="32" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 26 32"><path d="M25.7,13.2C25.7,6,20,0,13.2,0C6,0,0.3,6,0.3,13.2c0,7.5,10,18.8,12.8,18.8C15.7,32,25.7,20.7,25.7,13.2z M5.3,12.7c0-1.9,0.6-3.5,1.6-4.8v0c0,1.7,1.3,3,3,3c1.7,0,3.1-1.4,3.1-3c0-1.2-0.7-2.3-1.8-2.7c0.6-0.2,1.3-0.2,2-0.2c4,0,7.5,3.4,7.5,7.8c0,4-3.5,7.4-7.5,7.4C8.7,20.1,5.3,16.7,5.3,12.7L5.3,12.7z"/></svg>',
        'yammer' => '<svg width="32" height="32" viewBox="0 -19 256 256" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" preserveAspectRatio="xMidYMid"> <g> <path d="M245.767868,97.8609328 C245.231169,97.8342313 244.667768,97.828891 244.080337,97.828891 C234.238182,97.847582 163.465986,105.609694 167.017279,112.821756 C170.555221,119.959054 214.134659,123.422232 245.193787,123.435582 C251.703601,122.306111 256.419077,116.423781 255.970493,109.697686 C255.55128,103.793995 251.268367,99.0758488 245.767868,97.8609328 M221.768604,172.71044 C194.527784,157.786999 154.659848,139.843624 148.123333,144.414912 C141.541425,149.020913 199.844043,189.879473 208.468612,194.624321 C208.99463,194.910026 209.485937,195.1717 209.958552,195.422694 C215.378947,197.00075 221.392114,194.926047 224.604298,189.940886 C228.235696,184.266828 226.924654,176.833144 221.768604,172.71044 M221.768604,49.8704151 C226.924654,45.7477111 228.235696,38.3140272 224.604298,32.6453091 C221.392114,27.6574781 215.378947,25.593456 209.958552,27.1661714 C209.485937,27.4091546 208.99463,27.673499 208.468612,27.9565344 C199.844043,32.7093926 141.541425,73.5599423 148.123333,78.1712829 C154.659848,82.7399011 194.527784,64.7991963 221.768604,49.8704151 Z M58.4091277,159.242228 C50.3025673,182.130712 42.7994596,192.848674 25.5610029,192.848674 C23.8948323,192.848674 18.0952772,192.506896 17.7214569,192.472184 C12.1595447,192.186478 6.96611249,195.804525 5.4681611,201.395809 C3.74858766,207.748084 7.47878035,214.292609 13.7963436,216.102968 C18.3649619,216.906681 23.0564068,217.203067 27.2645554,217.203067 C59.039282,217.203067 69.5436328,198.909903 80.0346328,172.203112 L142.024721,17.5616595 C144.259633,10.5551988 140.366561,3.06544187 133.402823,0.83587072 C126.559241,-1.34029753 119.312467,2.27774907 116.861274,8.92641033 L73.303197,124.049716 L72.6196399,124.049716 L26.7999502,8.06128333 C23.6999118,1.50607714 16.0312551,-1.69275668 9.11290914,0.899954202 C2.0156635,3.56208885 -1.62908454,11.3268708 0.701952118,18.4668387 L58.4091277,159.242228 Z"></path> </g></svg>',
        'envelope' => '<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M31.3,5.1H0.7c0,0,0,0,0,0l0,0C0.3,5.1,0,5.4,0,5.8v20.4c0,0.4,0.3,0.7,0.7,0.7h30.6c0.4,0,0.7-0.3,0.7-0.7V5.8C32,5.4,31.7,5.1,31.3,5.1z M29.7,6.5l-9.1,9.1c0,0,0,0,0,0L16,20.1l-4.6-4.6c0,0,0,0,0,0l-9-9H29.7z M1.4,7.4L9.9,16l-8.6,8.6V7.4z M2.3,25.5l8.6-8.6l4.6,4.6c0.2,0.2,0.6,0.4,1,0l4.6-4.6l8.6,8.6H2.3z M30.6,24.6L22.1,16l8.6-8.6V24.6z"/></svg>',
        'comment-o' => '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve"><path d="M16,4.6c0,0-0.1,0-0.1,0c-2.4,0-4.7,0.5-6.8,1.3l0.1,0c-2,0.7-3.7,1.9-5,3.3l0,0c-1.1,1.2-1.8,2.8-1.9,4.5v0c0,1.4,0.5,2.8,1.3,3.8l0,0c1,1.3,2.2,2.3,3.5,3.1l0.1,0l1.6,0.9l-0.5,1.7c-0.3,1.2-0.7,2.2-1.3,3.1l0-0.1c1.9-0.8,3.5-1.8,4.9-3.1l0,0l0.8-0.7l1,0.1c0.7,0.1,1.5,0.1,2.3,0.1h0c0,0,0.1,0,0.1,0c2.4,0,4.7-0.5,6.8-1.3l-0.1,0c2-0.7,3.7-1.9,5-3.3l0,0c1.2-1.2,1.9-2.8,1.9-4.6s-0.7-3.4-1.9-4.6l0,0c-1.4-1.5-3-2.6-4.9-3.3l-0.1,0c-2-0.8-4.3-1.2-6.7-1.2C16.1,4.6,16,4.6,16,4.6L16,4.6L16,4.6z M32,13.7c0,2.2-0.8,4.2-2.2,5.8l0,0c-1.5,1.8-3.5,3.2-5.7,4.1l-0.1,0c-2.3,1-5,1.5-7.8,1.5c-0.1,0-0.2,0-0.2,0h0c-0.9,0-1.8-0.1-2.7-0.2l0.1,0c-2.3,2-5,3.5-8.1,4.3l-0.1,0c-0.6,0.2-1.3,0.3-2,0.4l-0.1,0H3.1c-0.2,0-0.4-0.1-0.5-0.2c-0.1-0.1-0.2-0.3-0.3-0.5l0,0v0c0,0,0-0.1,0-0.1c0,0,0-0.1,0-0.1l0,0c0-0.1,0-0.1,0-0.2c0,0,0,0,0,0c0,0,0-0.1,0.1-0.2l0.1-0.2l0.1-0.2L2.8,28c0.1-0.1,0.3-0.3,0.6-0.6L4,26.7c0.1-0.1,0.3-0.4,0.6-0.7c0.2-0.3,0.4-0.6,0.6-0.9l0,0c0.1-0.3,0.3-0.6,0.5-1.1c0.2-0.4,0.3-0.8,0.4-1.3l0-0.1c-1.8-1-3.3-2.3-4.4-3.9l0,0c-1-1.4-1.6-3.1-1.6-5v0C0,11.5,0.8,9.5,2.2,8l0,0c1.5-1.8,3.5-3.2,5.7-4.1l0.1,0c2.3-1,5-1.5,7.8-1.5c0.1,0,0.2,0,0.2,0h0c0.1,0,0.1,0,0.2,0c2.8,0,5.5,0.6,8,1.6L24,3.8c2.3,0.9,4.3,2.3,5.8,4.1l0,0C31.2,9.5,32,11.5,32,13.7L32,13.7L32,13.7z"/></svg>',
        'chevron-left' => '<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.4142 20.7071C17.8047 20.3166 17.8047 19.6834 17.4142 19.2929L10.1213 12L17.4142 4.70712C17.8047 4.3166 17.8047 3.68343 17.4142 3.29291L16.7071 2.5858C16.3166 2.19528 15.6834 2.19528 15.2929 2.5858L6.93934 10.9394C6.35355 11.5251 6.35355 12.4749 6.93934 13.0607L15.2929 21.4142C15.6834 21.8048 16.3166 21.8048 16.7071 21.4142L17.4142 20.7071Z"/></svg>',
        'chevron-right' => '<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M7.20696 20.7071C6.81643 20.3166 6.81643 19.6834 7.20696 19.2929L14.4998 12L7.20696 4.70712C6.81643 4.3166 6.81643 3.68343 7.20696 3.29291L7.91406 2.5858C8.30459 2.19528 8.93775 2.19528 9.32827 2.5858L17.6818 10.9394C18.2676 11.5251 18.2676 12.4749 17.6818 13.0607L9.32828 21.4142C8.93775 21.8048 8.30459 21.8048 7.91406 21.4142L7.20696 20.7071Z" /></svg>',
        'phone' => '<svg width="800px" height="800px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M4.7177 3.0919C5.94388 1.80096 7.9721 2.04283 8.98569 3.47641L10.2467 5.25989C11.0574 6.40656 10.9889 8.00073 10.0214 9.0194L9.7765 9.27719C9.77582 9.27897 9.7751 9.2809 9.77436 9.28299C9.76142 9.31935 9.7287 9.43513 9.7609 9.65489C9.82765 10.1104 10.1793 11.0361 11.607 12.5392C13.0391 14.0469 13.9078 14.4023 14.3103 14.4677C14.484 14.4959 14.5748 14.4714 14.6038 14.4612L15.0124 14.031C15.8862 13.111 17.2485 12.9298 18.347 13.5621L20.2575 14.6617C21.8904 15.6016 22.2705 17.9008 20.9655 19.2747L19.545 20.7703C19.1016 21.2371 18.497 21.6355 17.75 21.7092C15.9261 21.8893 11.701 21.6548 7.27161 16.9915C3.13844 12.64 2.35326 8.85513 2.25401 7.00591L2.92011 6.97016L2.25401 7.00591C2.20497 6.09224 2.61224 5.30855 3.1481 4.7444L4.7177 3.0919ZM7.7609 4.34237C7.24855 3.61773 6.32812 3.57449 5.80528 4.12493L4.23568 5.77743C3.90429 6.12632 3.73042 6.52621 3.75185 6.92552C3.83289 8.43533 4.48307 11.8776 8.35919 15.9584C12.4234 20.2373 16.1676 20.3581 17.6026 20.2165C17.8864 20.1885 18.1783 20.031 18.4574 19.7373L19.8779 18.2417C20.4907 17.5965 20.3301 16.4342 19.5092 15.9618L17.5987 14.8621C17.086 14.567 16.4854 14.6582 16.1 15.064L15.6445 15.5435L15.1174 15.0428C15.6445 15.5435 15.6438 15.5442 15.6432 15.545L15.6417 15.5464L15.6388 15.5495L15.6324 15.556L15.6181 15.5701C15.6078 15.5801 15.5959 15.591 15.5825 15.6028C15.5556 15.6264 15.5223 15.6533 15.4824 15.6816C15.4022 15.7384 15.2955 15.8009 15.1606 15.8541C14.8846 15.963 14.5201 16.0214 14.0699 15.9483C13.1923 15.8058 12.0422 15.1755 10.5194 13.5722C8.99202 11.9642 8.40746 10.7645 8.27675 9.87234C8.21022 9.41827 8.26346 9.05468 8.36116 8.78011C8.40921 8.64508 8.46594 8.53742 8.51826 8.45566C8.54435 8.41489 8.56922 8.38075 8.5912 8.35298C8.60219 8.33909 8.61246 8.32678 8.62182 8.31603L8.63514 8.30104L8.64125 8.29441L8.64415 8.2913L8.64556 8.2898C8.64625 8.28907 8.64694 8.28835 9.17861 8.79333L8.64695 8.28834L8.93376 7.98637C9.3793 7.51731 9.44403 6.72292 9.02189 6.12586L7.7609 4.34237Z" /><path d="M13.2595 1.87983C13.3257 1.47094 13.7122 1.19357 14.1211 1.25976C14.1464 1.26461 14.2279 1.27983 14.2705 1.28933C14.3559 1.30834 14.4749 1.33759 14.6233 1.38082C14.9201 1.46726 15.3347 1.60967 15.8323 1.8378C16.8286 2.29456 18.1544 3.09356 19.5302 4.46936C20.906 5.84516 21.705 7.17097 22.1617 8.16725C22.3899 8.66487 22.5323 9.07947 22.6187 9.37625C22.6619 9.52466 22.6912 9.64369 22.7102 9.72901C22.7197 9.77168 22.7267 9.80594 22.7315 9.83125L22.7373 9.86245C22.8034 10.2713 22.5286 10.6739 22.1197 10.7401C21.712 10.8061 21.3279 10.53 21.2601 10.1231C21.258 10.1121 21.2522 10.0828 21.2461 10.0551C21.2337 9.9997 21.2124 9.91188 21.1786 9.79572C21.1109 9.56339 20.9934 9.21806 20.7982 8.79238C20.4084 7.94207 19.7074 6.76789 18.4695 5.53002C17.2317 4.29216 16.0575 3.59117 15.2072 3.20134C14.7815 3.00618 14.4362 2.88865 14.2038 2.82097C14.0877 2.78714 13.9417 2.75363 13.8863 2.7413C13.4793 2.67347 13.1935 2.28755 13.2595 1.87983Z" /><path fill-rule="evenodd" clip-rule="evenodd" d="M13.4861 5.32931C13.5999 4.93103 14.015 4.70041 14.4133 4.81421L14.2072 5.53535C14.4133 4.81421 14.4136 4.81431 14.414 4.81441L14.4147 4.81462L14.4162 4.81506L14.4196 4.81604L14.4273 4.81835L14.4471 4.82451C14.4622 4.82934 14.481 4.83562 14.5035 4.84358C14.5484 4.85952 14.6077 4.88218 14.6805 4.91339C14.8262 4.97582 15.0253 5.07224 15.2698 5.21695C15.7593 5.50664 16.4275 5.98781 17.2124 6.77279C17.9974 7.55776 18.4786 8.22595 18.7683 8.71541C18.913 8.95992 19.0094 9.15899 19.0718 9.30467C19.103 9.37748 19.1257 9.43683 19.1416 9.48175C19.1496 9.5042 19.1559 9.52303 19.1607 9.5381L19.1669 9.55789L19.1692 9.56564L19.1702 9.56898L19.1706 9.57051L19.1708 9.57124C19.1709 9.5716 19.171 9.57195 18.4499 9.77799L19.171 9.57195C19.2848 9.97023 19.0542 10.3853 18.6559 10.4991C18.261 10.612 17.8496 10.3862 17.7317 9.99414L17.728 9.98336C17.7227 9.96833 17.7116 9.93875 17.6931 9.89555C17.6561 9.80921 17.589 9.66798 17.4774 9.47939C17.2544 9.10265 16.8517 8.5334 16.1518 7.83345C15.4518 7.13349 14.8826 6.73079 14.5058 6.50782C14.3172 6.3962 14.176 6.32911 14.0897 6.2921C14.0465 6.27359 14.0169 6.26256 14.0019 6.25722L13.9911 6.25353C13.599 6.13565 13.3733 5.7242 13.4861 5.32931Z" /></svg>'
         
    );    
    
    public static function register_custom() {
        if (has_filter('essb_custom_svg_icons')) {
            self::$icons = apply_filters( 'essb_custom_svg_icons', self::$icons );
        }

        if (has_filter('essb_custom_svg_icon_aliases')) {
            self::$aliases = apply_filters( 'essb_custom_svg_icon_aliases', self::$aliases );
        }
    }
    
    /**
     * Register user custom SVG icon
     * 
     * @param string $network
     * @param string $svg
     */
    public static function register_icon_replacement($network, $svg) {
        self::$icons[$network] = $svg;
    }
    
    public static function register_icon_alias($network, $alias) {
        self::$aliases[$network] = $alias;
    }
    
    /**
     * Return SVG icon code
     * 
     * @param string $icon
     * @return NULL|string
     */
    public static function get_icon($icon = '', $fill = '') {
        $list = self::get_all();
        
        /**
         * Check if alias exists only if networks does not have an icon
         */
        if (!array_key_exists( $icon, $list ) && array_key_exists( $icon, self::$aliases )) {
            $icon = self::$aliases[$icon];
        }
        
        if ( array_key_exists( $icon, $list ) ) {
            $repl = '<svg class="essb-svg-icon essb-svg-icon-'.esc_attr($icon).'" aria-hidden="true" role="img" focusable="false" ';
            
            if (!empty($fill)) {
                $repl .= 'fill="'.esc_attr($fill).'" ';    
            }
            
            $svg  = preg_replace( '/^<svg /', $repl, trim( $list[ $icon ] ) ); // Add extra attributes to SVG code.
            $svg  = preg_replace( "/([\n\t]+)/", ' ', $svg ); // Remove newlines & tabs.
            $svg  = preg_replace( '/>\s*</', '><', $svg );    // Remove whitespace between SVG tags.
            
            // Make sure that only our allowed tags and attributes are included.
            $svg = wp_kses(
                $svg,
                array(
                    'svg'     => array(
                        'class'       => true,
                        'xmlns'       => true,
                        'width'       => true,
                        'height'      => true,
                        'viewbox'     => true,
                        'aria-hidden' => true,
                        'role'        => true,
                        'focusable'   => true,
                    ),
                    'path'    => array(
                        'fill'      => true,
                        'fill-rule' => true,
                        'd'         => true,
                        'transform' => true,
                    ),
                    'polygon' => array(
                        'fill'      => true,
                        'fill-rule' => true,
                        'points'    => true,
                        'transform' => true,
                        'focusable' => true,
                    ),
                )
                );
            
            if ( ! $svg ) {
                return null;
            }
            
            return $svg;
        }
        
        return null;
    }
    
    /**
     * Return all icons with filter applying. Custom icons can be added via the essb_svg_icons filter
     * @return array
     */
    public static function get_all() {
        if (has_filter('essb_svg_icons')) {
            return apply_filters( 'essb_svg_icons', self::$icons );
        }
        else {
            return self::$icons;
        }
    }
    
    public static function prepare_svg_code($icon, $code, $fill = '') {
        $repl = '<svg class="essb-svg-icon essb-svg-icon-'.esc_attr($icon).'" aria-hidden="true" role="img" focusable="false" ';
        
        if (!empty($fill)) {
            $repl .= 'fill="'.esc_attr($fill).'" ';
        }
        
        $svg  = preg_replace( '/^<svg /', $repl, trim( $code ) ); // Add extra attributes to SVG code.
        $svg  = preg_replace( "/([\n\t]+)/", ' ', $svg ); // Remove newlines & tabs.
        $svg  = preg_replace( '/>\s*</', '><', $svg );    // Remove whitespace between SVG tags.
        
        // Make sure that only our allowed tags and attributes are included.
        $svg = wp_kses(
            $svg,
            array(
                'svg'     => array(
                    'class'       => true,
                    'xmlns'       => true,
                    'width'       => true,
                    'height'      => true,
                    'viewbox'     => true,
                    'aria-hidden' => true,
                    'role'        => true,
                    'focusable'   => true,
                ),
                'path'    => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'd'         => true,
                    'transform' => true,
                ),
                'polygon' => array(
                    'fill'      => true,
                    'fill-rule' => true,
                    'points'    => true,
                    'transform' => true,
                    'focusable' => true,
                ),
            )
            );
        
        if ( ! $svg ) {
            return null;
        }
        
        return $svg;
        
    }
    
    public static function get_all_with_aliases() {
        $icons = self::get_all();
        
        foreach ($icons as $icon => $svg) {
            $icons[$icon] = self::prepare_svg_code($icon, $svg);
        }
        
        foreach (self::$aliases as $key => $bind) {
            if (isset($icons[$bind]) && !isset($icons[$key])) {
                $icons[$key] = $icons[$bind];
            }
        }
        
        return $icons;
    }
    
    /**
     * Generate icon font code replacement with SVG inline icon (or return icon font code)
     * 
     * @param string $icon
     * @return string
     */
    public static function replace_font_icon($icon = '', $additional_classes = '') {
        $output = '';
        
        $icon_svg = self::get_icon($icon);
        
        if (!empty($icon_svg)) {
            $output .= '<i class="essb_svg_icon essb_svg_icon_'.esc_attr($icon).(!empty($additional_classes) ? ' ' . $additional_classes : '').'">' . $icon_svg . '</i>';
        }
        else {
            $output .= '<i class="essb_icon_'.esc_attr($icon).(!empty($additional_classes) ? ' ' . $additional_classes : '').'"></i>';
        }
        
        return $output;
    }
}