import { createElement } from '@wordpress/element'

import { __ } from 'ct-i18n'
import { registerBlockType } from '@wordpress/blocks'
import { InspectorControls } from '@wordpress/block-editor'
import { Panel, PanelBody, ToggleControl } from '@wordpress/components'
import Preview from './Preview'

registerBlockType('blocksy/woocommerce-price-filter', {
	title: __('Filter by Price Controls', 'blocksy-companion'),
	description: __(
		'Widget for filtering the WooCommerce products by price.',
		'blocksy-companion'
	),
	icon: 'filter',
	icon: {
		src: (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				viewBox="0 0 24 24"
				className="wc-block-editor-components-block-icon">
				<path d="M10.25,10.25c0,.17133.09821.40308.41229.62299.31183.2182.78241.37701,1.33771.37701.82538,0,1.6048.23297,2.19788.64807.5907.41351,1.05212,1.0567,1.05212,1.85193s-.46143,1.43842-1.05212,1.85193c-.4093.2865-.90729.48615-1.44788.58246v.31561c0,.41418-.33582.75-.75.75s-.75-.33582-.75-.75v-.31561c-.54059-.09631-1.03857-.29596-1.44788-.58246-.5907-.41351-1.05212-1.0567-1.05212-1.85193,0-.41418.33582-.75.75-.75s.75.33582.75.75c0,.17133.09821.40308.41229.62299.31183.2182.78241.37701,1.33771.37701s1.02588-.15881,1.33771-.37701c.31409-.21991.41229-.45166.41229-.62299s-.09821-.40308-.41229-.62299c-.31183-.2182-.78241-.37701-1.33771-.37701-.82538,0-1.6048-.23297-2.19788-.64807-.5907-.41351-1.05212-1.0567-1.05212-1.85193,0-.79517.46143-1.43835,1.05212-1.85187.4093-.2865.90729-.48621,1.44788-.58252v-.31561c0-.41418.33582-.75.75-.75s.75.33582.75.75v.31561c.54059.09631,1.03857.29602,1.44788.58252.5907.41351,1.05212,1.0567,1.05212,1.85187,0,.41418-.33582.75-.75.75s-.75-.33582-.75-.75c0-.17133-.09821-.40314-.41229-.62299-.31183-.21826-.78241-.37701-1.33771-.37701s-1.02588.15875-1.33771.37701c-.31409.21985-.41229.45166-.41229.62299ZM20.21289,13.47168l-1.36816,1.38086v1.95508c0,1.14648-.92871,2.0791-2.07129,2.0791h-1.9375l-1.36621,1.38184c-.38867.39062-.91016.60645-1.46777.60645-.55713,0-1.07812-.21582-1.4668-.60645l-1.36719-1.38184h-1.9375c-1.14258,0-2.07178-.93262-2.07178-2.0791v-1.95508l-1.37158-1.38086c-.8042-.81152-.8042-2.13037,0-2.94043l1.37158-1.38086v-1.95508c0-1.14746.9292-2.08057,2.07178-2.08057h1.9375l1.36719-1.37891c.38477-.38818.91943-.61084,1.4668-.61084.54785,0,1.08301.22266,1.46777.61084l1.36621,1.37891h1.9375c1.14258,0,2.07129.93311,2.07129,2.08057v1.95557l1.36816,1.38037c.80371.81006.80371,2.12891,0,2.94043ZM17.63086,14.06055l1.57715-1.58887c.2627-.26465.26172-.67969,0-.94482l-1.57715-1.58789c-.12891-.13232-.20312-.31299-.20312-.49707v-2.24756c0-.37793-.28125-.66309-.65527-.66309h-2.23047c-.18945,0-.36816-.07373-.50195-.20801l-1.57617-1.58936c-.24902-.25-.67627-.25-.92432,0l-1.57568,1.58887c-.12988.13232-.31348.2085-.50244.2085h-2.23047c-.37305,0-.6543.28516-.6543.66309v2.24756c0,.18457-.07422.36572-.20361.49707l-1.57617,1.58789c-.26318.26514-.26318.68018,0,.94482l1.57617,1.58887c.12939.13086.20361.31152.20361.49707v2.24805c0,.37793.28125.66211.6543.66211h2.23047c.1875,0,.37061.07617.50244.20898l1.57568,1.58887c.12793.12891.29199.19922.4624.19922h.00098c.16992,0,.33398-.07031.46094-.19922l1.57617-1.58887c.13379-.13477.31152-.20898.50195-.20898h2.23047c.37402,0,.65527-.28418.65527-.66211v-2.24805c0-.18457.07422-.36523.20312-.49707Z"/>
			</svg>
		),
	},
	category: 'widgets',
	supports: {
		html: false,
		inserter: false,
		lock: false,
	},
	attributes: {
		showTooltips: {
			type: 'boolean',
			default: true,
		},

		showPrices: {
			type: 'boolean',
			default: true,
		},

		showResetButton: {
			type: 'boolean',
			default: false,
		},
	},
	edit: ({ attributes, setAttributes }) => {
		const { showTooltips, showResetButton, showPrices } = attributes

		return (
			<>
				<Preview attributes={attributes} />
				<InspectorControls>
					<Panel header="Filter Settings">
						<PanelBody>
							<ToggleControl
								label={__('Show Tooltip', 'blocksy-companion')}
								checked={showTooltips}
								onChange={() =>
									setAttributes({
										showTooltips: !showTooltips,
									})
								}
							/>
						</PanelBody>

						<PanelBody>
							<ToggleControl
								label={__('Show Prices', 'blocksy-companion')}
								checked={showPrices}
								onChange={() =>
									setAttributes({
										showPrices: !showPrices,
									})
								}
							/>
						</PanelBody>

						<PanelBody>
							<ToggleControl
								label={__(
									'Show Reset Button',
									'blocksy-companion'
								)}
								checked={showResetButton}
								onChange={() =>
									setAttributes({
										showResetButton: !showResetButton,
									})
								}
							/>
						</PanelBody>
					</Panel>
				</InspectorControls>
			</>
		)
	},
	save: function () {
		return <div>Blocksy: Price Filter</div>
	},
})

wp.blocks.registerBlockVariation('blocksy/widgets-wrapper', {
	name: 'blocksy-price-filter',
	title: __('Filter by Price', 'blocksy-companion'),
	attributes: {
		heading: __('Filter', 'blocksy-companion'),
		block: 'blocksy/woocommerce-price-filter',
	},
	isActive: (attributes) =>
		attributes.block === 'blocksy/woocommerce-price-filter',
	icon: {
		src: (
			<svg
				xmlns="http://www.w3.org/2000/svg"
				viewBox="0 0 24 24"
				className="wc-block-editor-components-block-icon">
				<path d="M10.25,10.25c0,.17133.09821.40308.41229.62299.31183.2182.78241.37701,1.33771.37701.82538,0,1.6048.23297,2.19788.64807.5907.41351,1.05212,1.0567,1.05212,1.85193s-.46143,1.43842-1.05212,1.85193c-.4093.2865-.90729.48615-1.44788.58246v.31561c0,.41418-.33582.75-.75.75s-.75-.33582-.75-.75v-.31561c-.54059-.09631-1.03857-.29596-1.44788-.58246-.5907-.41351-1.05212-1.0567-1.05212-1.85193,0-.41418.33582-.75.75-.75s.75.33582.75.75c0,.17133.09821.40308.41229.62299.31183.2182.78241.37701,1.33771.37701s1.02588-.15881,1.33771-.37701c.31409-.21991.41229-.45166.41229-.62299s-.09821-.40308-.41229-.62299c-.31183-.2182-.78241-.37701-1.33771-.37701-.82538,0-1.6048-.23297-2.19788-.64807-.5907-.41351-1.05212-1.0567-1.05212-1.85193,0-.79517.46143-1.43835,1.05212-1.85187.4093-.2865.90729-.48621,1.44788-.58252v-.31561c0-.41418.33582-.75.75-.75s.75.33582.75.75v.31561c.54059.09631,1.03857.29602,1.44788.58252.5907.41351,1.05212,1.0567,1.05212,1.85187,0,.41418-.33582.75-.75.75s-.75-.33582-.75-.75c0-.17133-.09821-.40314-.41229-.62299-.31183-.21826-.78241-.37701-1.33771-.37701s-1.02588.15875-1.33771.37701c-.31409.21985-.41229.45166-.41229.62299ZM20.21289,13.47168l-1.36816,1.38086v1.95508c0,1.14648-.92871,2.0791-2.07129,2.0791h-1.9375l-1.36621,1.38184c-.38867.39062-.91016.60645-1.46777.60645-.55713,0-1.07812-.21582-1.4668-.60645l-1.36719-1.38184h-1.9375c-1.14258,0-2.07178-.93262-2.07178-2.0791v-1.95508l-1.37158-1.38086c-.8042-.81152-.8042-2.13037,0-2.94043l1.37158-1.38086v-1.95508c0-1.14746.9292-2.08057,2.07178-2.08057h1.9375l1.36719-1.37891c.38477-.38818.91943-.61084,1.4668-.61084.54785,0,1.08301.22266,1.46777.61084l1.36621,1.37891h1.9375c1.14258,0,2.07129.93311,2.07129,2.08057v1.95557l1.36816,1.38037c.80371.81006.80371,2.12891,0,2.94043ZM17.63086,14.06055l1.57715-1.58887c.2627-.26465.26172-.67969,0-.94482l-1.57715-1.58789c-.12891-.13232-.20312-.31299-.20312-.49707v-2.24756c0-.37793-.28125-.66309-.65527-.66309h-2.23047c-.18945,0-.36816-.07373-.50195-.20801l-1.57617-1.58936c-.24902-.25-.67627-.25-.92432,0l-1.57568,1.58887c-.12988.13232-.31348.2085-.50244.2085h-2.23047c-.37305,0-.6543.28516-.6543.66309v2.24756c0,.18457-.07422.36572-.20361.49707l-1.57617,1.58789c-.26318.26514-.26318.68018,0,.94482l1.57617,1.58887c.12939.13086.20361.31152.20361.49707v2.24805c0,.37793.28125.66211.6543.66211h2.23047c.1875,0,.37061.07617.50244.20898l1.57568,1.58887c.12793.12891.29199.19922.4624.19922h.00098c.16992,0,.33398-.07031.46094-.19922l1.57617-1.58887c.13379-.13477.31152-.20898.50195-.20898h2.23047c.37402,0,.65527-.28418.65527-.66211v-2.24805c0-.18457.07422-.36523.20312-.49707Z"/>
			</svg>
		),
	},
})
